/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.BuildReporter;
import io.quarkus.bot.buildreporter.githubactions.BuildReporterConfig;
import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.BuildReportsUnarchiver;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.WorkflowRunAnalyzer;
import io.quarkus.bot.buildreporter.githubactions.WorkflowUtils;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReport;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHArtifact;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHWorkflow;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.GitHub;

@Singleton
public class BuildReporterEventHandler {
    private static final Logger LOG = Logger.getLogger(BuildReporterEventHandler.class);
    private static final String LABEL_FLAKY_TEST = "triage/flaky-test";
    @Inject
    WorkflowRunAnalyzer workflowRunAnalyzer;
    @Inject
    BuildReporter buildReporter;
    @Inject
    BuildReportsUnarchiver buildReportsUnarchiver;

    public void handle(GHEventPayload.WorkflowRun workflowRunPayload, BuildReporterConfig buildReporterConfig, GitHub gitHub, DynamicGraphQLClient gitHubGraphQLClient) throws IOException {
        if (buildReporterConfig.getMonitoredWorkflows() == null || buildReporterConfig.getMonitoredWorkflows().isEmpty()) {
            return;
        }
        GHWorkflowRun workflowRun = workflowRunPayload.getWorkflowRun();
        GHWorkflow workflow = workflowRunPayload.getWorkflow();
        if (!buildReporterConfig.getMonitoredWorkflows().contains(workflow.getName())) {
            return;
        }
        switch (workflowRunPayload.getAction()) {
            case "completed": {
                this.handleCompleted(workflow, workflowRun, buildReporterConfig, gitHub, gitHubGraphQLClient);
                break;
            }
            case "requested": {
                this.handleRequested(workflow, workflowRun, buildReporterConfig, gitHub, gitHubGraphQLClient);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompleted(GHWorkflow workflow, GHWorkflowRun workflowRun, BuildReporterConfig buildReporterConfig, GitHub gitHub, DynamicGraphQLClient gitHubGraphQLClient) throws IOException {
        boolean artifactsAvailable;
        List<GHArtifact> artifacts;
        try {
            ArtifactsAreReady artifactsAreReady = new ArtifactsAreReady(workflowRun);
            Awaitility.await().atMost(Duration.ofMinutes(5L)).pollDelay(Duration.ofSeconds(5L)).pollInterval(Duration.ofSeconds(30L)).ignoreExceptions().until((Callable)artifactsAreReady);
            artifacts = artifactsAreReady.getArtifacts();
            artifactsAvailable = true;
        }
        catch (ConditionTimeoutException e) {
            if (workflowRun.getConclusion() != GHWorkflowRun.Conclusion.CANCELLED) {
                LOG.warn((Object)("Workflow run " + workflowRun.getRepository().getFullName() + "#" + workflowRun.getName() + ":" + workflowRun.getId() + " - Unable to get the artifacts in a timely manner, ignoring them"));
            }
            artifacts = Collections.emptyList();
            artifactsAvailable = false;
        }
        Path allBuildReportsDirectory = artifactsAvailable ? Files.createTempDirectory("build-reports-analyzer-", new FileAttribute[0]) : null;
        try {
            GHWorkflowRun.Conclusion conclusion = workflowRun.getConclusion();
            if (workflowRun.getEvent() == GHEvent.PULL_REQUEST) {
                Optional<GHPullRequest> pullRequestOptional = this.getAssociatedPullRequest(workflowRun, artifacts);
                if (pullRequestOptional.isEmpty()) {
                    LOG.error((Object)("Workflow run #" + workflowRun.getId() + " - Unable to find the associated pull request"));
                    return;
                }
                GHPullRequest pullRequest = pullRequestOptional.get();
                WorkflowContext workflowContext = new WorkflowContext(pullRequest);
                BuildReporterEventHandler.hideOutdatedWorkflowRunResults(buildReporterConfig, workflowContext, (GHIssue)pullRequest, workflow.getName(), gitHubGraphQLClient);
                if (conclusion == GHWorkflowRun.Conclusion.SUCCESS && pullRequest.isDraft() || conclusion == GHWorkflowRun.Conclusion.CANCELLED) {
                    return;
                }
                Map<String, Optional<BuildReports>> buildReportsMap = this.downloadBuildReports(workflowContext, allBuildReportsDirectory, artifacts, artifactsAvailable, workflowRun.getRunAttempt());
                List<GHWorkflowJob> jobs = workflowRun.listJobs().toList().stream().sorted(buildReporterConfig.getJobNameComparator()).collect(Collectors.toList());
                Optional<WorkflowReport> workflowReportOptional = this.workflowRunAnalyzer.getReport(workflow.getName(), workflowRun, workflowContext, jobs, buildReportsMap);
                if (workflowReportOptional.isEmpty()) {
                    return;
                }
                WorkflowReport workflowReport = workflowReportOptional.get();
                Optional<String> reportCommentOptional = this.buildReporter.generateReportComment(workflow.getName(), workflowRun, buildReporterConfig, workflowContext, workflowReport, artifactsAvailable, true, BuildReporterEventHandler.hasOtherPendingWorkflowRuns(pullRequest, buildReporterConfig));
                if (reportCommentOptional.isEmpty()) {
                    return;
                }
                String reportComment = reportCommentOptional.get();
                if (!buildReporterConfig.isDryRun()) {
                    pullRequest.comment(reportComment);
                } else {
                    LOG.info((Object)("Pull request #" + pullRequest.getNumber() + " - Add test failures:\n" + reportComment));
                }
                if (workflowReport.hasFlakyTests()) {
                    if (!buildReporterConfig.isDryRun()) {
                        pullRequest.addLabels(new String[]{LABEL_FLAKY_TEST});
                    } else {
                        LOG.info((Object)("Pull request #" + pullRequest.getNumber() + " - Add label triage/flaky-test"));
                    }
                }
            } else {
                Optional<GHIssue> reportIssueOptional = this.getAssociatedReportIssue(gitHub, workflowRun, artifacts);
                if (reportIssueOptional.isEmpty()) {
                    return;
                }
                GHIssue reportIssue = reportIssueOptional.get();
                WorkflowContext workflowContext = new WorkflowContext(reportIssue);
                BuildReporterEventHandler.hideOutdatedWorkflowRunResults(buildReporterConfig, workflowContext, reportIssue, workflow.getName(), gitHubGraphQLClient);
                if (conclusion == GHWorkflowRun.Conclusion.SUCCESS && reportIssue.getState() == GHIssueState.OPEN) {
                    String fixedComment = ":heavy_check_mark: **Build fixed:**\n* Link to latest CI run: " + workflowRun.getHtmlUrl().toString();
                    if (!buildReporterConfig.isDryRun()) {
                        reportIssue.comment(fixedComment);
                        reportIssue.close();
                    } else {
                        LOG.info((Object)("Issue #" + reportIssue.getNumber() + " - Add comment: " + fixedComment));
                        LOG.info((Object)("Issue #" + reportIssue.getNumber() + " - Closing report issue"));
                    }
                    return;
                }
                if (conclusion != GHWorkflowRun.Conclusion.FAILURE) {
                    return;
                }
                if (!buildReporterConfig.isDryRun()) {
                    reportIssue.reopen();
                } else {
                    LOG.info((Object)("Issue #" + reportIssue.getNumber() + " - Reopening report issue"));
                }
                Map<String, Optional<BuildReports>> buildReportsMap = this.downloadBuildReports(workflowContext, allBuildReportsDirectory, artifacts, artifactsAvailable, workflowRun.getRunAttempt());
                List<GHWorkflowJob> jobs = workflowRun.listJobs().toList().stream().sorted(buildReporterConfig.getJobNameComparator()).collect(Collectors.toList());
                Optional<WorkflowReport> workflowReportOptional = this.workflowRunAnalyzer.getReport(workflow.getName(), workflowRun, workflowContext, jobs, buildReportsMap);
                if (workflowReportOptional.isEmpty()) {
                    return;
                }
                WorkflowReport workflowReport = workflowReportOptional.get();
                Optional<String> reportCommentOptional = this.buildReporter.generateReportComment(workflow.getName(), workflowRun, buildReporterConfig, workflowContext, workflowReport, artifactsAvailable, false, false);
                if (reportCommentOptional.isEmpty()) {
                    String defaultFailureComment = "The build is failing and we were not able to generate a report:\n* Link to latest CI run: " + workflowRun.getHtmlUrl().toString();
                    if (!buildReporterConfig.isDryRun()) {
                        reportIssue.comment(defaultFailureComment);
                    } else {
                        LOG.info((Object)("Issue #" + reportIssue.getNumber() + " - Add comment: " + defaultFailureComment));
                    }
                    return;
                }
                String reportComment = reportCommentOptional.get();
                if (!buildReporterConfig.isDryRun()) {
                    reportIssue.comment(reportComment);
                } else {
                    LOG.info((Object)("Issue #" + reportIssue.getNumber() + " - Add test failures:\n" + reportComment));
                }
            }
        }
        finally {
            if (allBuildReportsDirectory != null) {
                try {
                    Files.walk(allBuildReportsDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to delete temp directory " + allBuildReportsDirectory));
                }
            }
        }
    }

    private Optional<GHPullRequest> getAssociatedPullRequest(GHWorkflowRun workflowRun, List<GHArtifact> artifacts) throws NumberFormatException, IOException {
        Optional<GHArtifact> pullRequestNumberArtifact = artifacts.stream().filter(a -> a.getName().startsWith("pull-request-number-")).findFirst();
        if (!pullRequestNumberArtifact.isEmpty()) {
            GHPullRequest pullRequest = workflowRun.getRepository().getPullRequest(Integer.valueOf(pullRequestNumberArtifact.get().getName().replace("pull-request-number-", "")).intValue());
            return Optional.of(pullRequest);
        }
        LOG.warn((Object)("Workflow run #" + workflowRun.getId() + " - Unable to get the pull request artifact, trying with sha"));
        List pullRequests = workflowRun.getRepository().queryPullRequests().state(GHIssueState.OPEN).head(workflowRun.getHeadRepository().getOwnerName() + ":" + workflowRun.getHeadBranch()).list().toList();
        if (!pullRequests.isEmpty()) {
            return Optional.of((GHPullRequest)pullRequests.get(0));
        }
        return Optional.empty();
    }

    private Optional<GHIssue> getAssociatedReportIssue(GitHub gitHub, GHWorkflowRun workflowRun, List<GHArtifact> artifacts) throws NumberFormatException, IOException {
        Optional<GHArtifact> reportIssueNumberArtifact = artifacts.stream().filter(a -> a.getName().startsWith("report-issue-number-")).findFirst();
        if (!reportIssueNumberArtifact.isEmpty()) {
            String issueReference = reportIssueNumberArtifact.get().getName().replace("report-issue-number-", "");
            if (issueReference.contains("#")) {
                String[] issueReferenceParts = issueReference.split("#", 2);
                return Optional.of(gitHub.getRepository(issueReferenceParts[0]).getIssue(Integer.valueOf(issueReferenceParts[1]).intValue()));
            }
            return Optional.of(workflowRun.getRepository().getIssue(Integer.valueOf(issueReference).intValue()));
        }
        return Optional.empty();
    }

    private Map<String, Optional<BuildReports>> downloadBuildReports(WorkflowContext workflowContext, Path allBuildReportsDirectory, List<GHArtifact> artifacts, boolean artifactsAvailable, long runAttempt) throws IOException {
        if (!artifactsAvailable) {
            return Collections.emptyMap();
        }
        Map<String, GHArtifact> buildReportsArtifacts = WorkflowUtils.getBuildReportsArtifacts(artifacts, runAttempt);
        HashMap<String, Optional<BuildReports>> buildReportsMap = new HashMap<String, Optional<BuildReports>>();
        HashSet<String> alreadyHandledArtifacts = new HashSet<String>();
        for (Map.Entry<String, GHArtifact> artifactEntry : buildReportsArtifacts.entrySet()) {
            String jobName = artifactEntry.getKey();
            GHArtifact artifact = artifactEntry.getValue();
            if (alreadyHandledArtifacts.contains(artifact.getName())) continue;
            Path jobDirectory = allBuildReportsDirectory.resolve(artifact.getName());
            Optional<BuildReports> buildReportsOptional = this.buildReportsUnarchiver.getBuildReports(workflowContext, artifact, jobDirectory);
            buildReportsMap.put(jobName, buildReportsOptional);
            alreadyHandledArtifacts.add(artifact.getName());
        }
        return buildReportsMap;
    }

    private void handleRequested(GHWorkflow workflow, GHWorkflowRun workflowRun, BuildReporterConfig buildReporterConfig, GitHub gitHub, DynamicGraphQLClient gitHubGraphQLClient) throws IOException {
        List pullRequests = workflowRun.getRepository().queryPullRequests().state(GHIssueState.OPEN).head(workflowRun.getHeadRepository().getOwnerName() + ":" + workflowRun.getHeadBranch()).list().toList();
        if (pullRequests.isEmpty()) {
            return;
        }
        BuildReporterEventHandler.hideOutdatedWorkflowRunResults(buildReporterConfig, new WorkflowContext((GHPullRequest)pullRequests.get(0)), (GHIssue)pullRequests.get(0), workflow.getName(), gitHubGraphQLClient);
    }

    private static void hideOutdatedWorkflowRunResults(BuildReporterConfig buildReporterConfig, WorkflowContext workflowContext, GHIssue issue, String workflowName, DynamicGraphQLClient gitHubGraphQLClient) throws IOException {
        List comments = issue.getComments();
        for (GHIssueComment comment : comments) {
            boolean noOldMarkersFound;
            boolean bl = noOldMarkersFound = !comment.getBody().contains("<!-- Quarkus-GitHub-Bot/msg-id:workflow-run-status-active -->") && !comment.getBody().contains(WorkflowUtils.getOldActiveStatusCommentMarker(workflowName));
            if (!comment.getBody().contains("<!-- Build-Reporter/msg-id:workflow-run-status-active -->") && !comment.getBody().contains(WorkflowUtils.getActiveStatusCommentMarker(workflowName)) && noOldMarkersFound) continue;
            String updatedComment = BuildReporterEventHandler.getUpdatedComment(workflowName, comment);
            if (!buildReporterConfig.isDryRun()) {
                try {
                    comment.update(updatedComment);
                }
                catch (IOException e) {
                    LOG.error((Object)(workflowContext.getLogContext() + " - Unable to hide outdated workflow run status for comment " + comment.getId()));
                }
                try {
                    BuildReporterEventHandler.minimizeOutdatedComment(gitHubGraphQLClient, comment);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Object)(workflowContext.getLogContext() + " - Unable to minimize outdated workflow run status for comment " + comment.getId()));
                }
                continue;
            }
            LOG.info((Object)(workflowContext.getLogContext() + " - Hide outdated workflow run status " + comment.getId()));
        }
    }

    private static String getUpdatedComment(String workflowName, GHIssueComment comment) {
        StringBuilder updatedComment = new StringBuilder();
        updatedComment.append("---\n> :waning_crescent_moon: **_This workflow status is outdated as a new workflow run has been triggered._**\n---\n\n");
        if (comment.getBody().contains(WorkflowUtils.getOldActiveStatusCommentMarker(workflowName))) {
            updatedComment.append(comment.getBody().replace(WorkflowUtils.getOldActiveStatusCommentMarker(workflowName), WorkflowUtils.getHiddenStatusCommentMarker(workflowName)).replace("<!-- Quarkus-GitHub-Bot/msg-id:workflow-run-status-active -->", WorkflowUtils.getHiddenStatusCommentMarker(workflowName)));
        } else {
            updatedComment.append(comment.getBody().replace(WorkflowUtils.getActiveStatusCommentMarker(workflowName), WorkflowUtils.getHiddenStatusCommentMarker(workflowName)).replace("<!-- Build-Reporter/msg-id:workflow-run-status-active -->", WorkflowUtils.getHiddenStatusCommentMarker(workflowName)));
        }
        return updatedComment.toString();
    }

    private static void minimizeOutdatedComment(DynamicGraphQLClient gitHubGraphQLClient, GHIssueComment comment) throws ExecutionException, InterruptedException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("subjectId", comment.getNodeId());
        gitHubGraphQLClient.executeSync("mutation MinimizeOutdatedContent($subjectId: ID!) {\n  minimizeComment(input: {\n    subjectId: $subjectId,\n    classifier: OUTDATED}) {\n      minimizedComment {\n        isMinimized\n      }\n    }\n}\n", variables);
    }

    private static boolean hasOtherPendingWorkflowRuns(GHPullRequest pullRequest, BuildReporterConfig buildReporterConfig) {
        try {
            return pullRequest.getRepository().queryWorkflowRuns().headSha(pullRequest.getHead().getSha()).list().toList().stream().filter(w -> BuildReporterEventHandler.isWorkflowMonitored(w, buildReporterConfig)).anyMatch(w -> w.getStatus() == GHWorkflowRun.Status.QUEUED || w.getStatus() == GHWorkflowRun.Status.IN_PROGRESS);
        }
        catch (Exception e) {
            LOG.warnf((Throwable)e, "Error while getting workflow runs for %s#%s", (Object)pullRequest.getRepository().getFullName(), (Object)pullRequest.getNumber());
            return false;
        }
    }

    private static boolean isWorkflowMonitored(GHWorkflowRun workflowRun, BuildReporterConfig buildReporterConfig) {
        for (String workflowName : buildReporterConfig.getMonitoredWorkflows()) {
            if (!workflowName.equals(workflowRun.getName())) continue;
            return true;
        }
        return false;
    }

    private static final class ArtifactsAreReady
    implements Callable<Boolean> {
        private final GHWorkflowRun workflowRun;
        private List<GHArtifact> artifacts;

        private ArtifactsAreReady(GHWorkflowRun workflowRun) {
            this.workflowRun = workflowRun;
        }

        @Override
        public Boolean call() throws Exception {
            this.artifacts = this.workflowRun.listArtifacts().toList();
            boolean useNewBuildReportsArtifactNamePattern = this.artifacts.stream().anyMatch(a -> WorkflowUtils.matchesNewBuildReportsArtifactNamePattern(a.getName()));
            String buildReportsArtifactNamePrefix = useNewBuildReportsArtifactNamePattern ? "build-reports-" + this.workflowRun.getRunAttempt() + "-" : "build-reports-";
            return this.artifacts.stream().anyMatch(a -> a.getName().startsWith(buildReportsArtifactNamePrefix));
        }

        public List<GHArtifact> getArtifacts() {
            return this.artifacts;
        }
    }
}

