/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReport;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportJobIncludeStrategy;
import io.quarkus.qute.CheckedTemplate;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.TemplateInstance;
import jakarta.enterprise.context.ApplicationScoped;
import org.kohsuke.github.GHCheckRun;

@ApplicationScoped
public class WorkflowReportFormatter {
    public String getCheckRunReportSummary(WorkflowReport report, WorkflowContext workflowContext, boolean artifactsAvailable, WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy) {
        return Templates.checkRunReportSummary(report, workflowContext, artifactsAvailable, workflowReportJobIncludeStrategy).render();
    }

    public String getCheckRunReport(WorkflowReport report, boolean develocityEnabled, String develocityUrl, boolean includeStackTraces, boolean includeFailureLinks) {
        return Templates.checkRunReport(report, develocityEnabled, develocityUrl, includeStackTraces, includeFailureLinks).render();
    }

    public String getReportComment(WorkflowReport report, boolean artifactsAvailable, GHCheckRun checkRun, String messageIdActive, String workflowRunId, String buildScansCheckRunMarker, boolean develocityEnabled, String develocityUrl, boolean indicateSuccess, boolean hasOtherPendingCheckRuns, boolean includeStackTraces, boolean includeFailureLinks, WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy) {
        return Templates.commentReport(report, artifactsAvailable, checkRun, messageIdActive, workflowRunId, buildScansCheckRunMarker, develocityEnabled, develocityUrl, indicateSuccess, hasOtherPendingCheckRuns, includeStackTraces, includeFailureLinks, workflowReportJobIncludeStrategy).render();
    }

    @CheckedTemplate
    private static class Templates {
        private Templates() {
        }

        public static native TemplateInstance checkRunReportSummary(WorkflowReport var0, WorkflowContext var1, boolean var2, WorkflowReportJobIncludeStrategy var3);

        public static native TemplateInstance checkRunReport(WorkflowReport var0, boolean var1, String var2, boolean var3, boolean var4);

        public static native TemplateInstance commentReport(WorkflowReport var0, boolean var1, GHCheckRun var2, String var3, String var4, String var5, boolean var6, String var7, boolean var8, boolean var9, boolean var10, boolean var11, WorkflowReportJobIncludeStrategy var12);
    }

    @TemplateExtension
    public class TemplateExtensions {
        public static String escapeHtml(String html) {
            if (html == null || html.isBlank()) {
                return html;
            }
            return html.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        }
    }
}

