/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.github.GHArtifact;

public final class WorkflowUtils {
    private static final Pattern BUILD_REPORTS_ARTIFACT_NAME_PATTERN = Pattern.compile(Pattern.quote("build-reports-") + "(?:([0-9]+)-)?(.*)");

    public static String getFilePath(String moduleName, String fullClassName) {
        String classPath = fullClassName.replace(".", "/");
        int dollarIndex = classPath.indexOf(36);
        if (dollarIndex > 0) {
            classPath = classPath.substring(0, dollarIndex);
        }
        return moduleName + "/src/test/java/" + classPath + ".java";
    }

    public static String getActiveStatusCommentMarker(String workflowName) {
        return String.format("<!-- Build-Reporter/msg-id:workflow-run-status-active:%1$s -->", workflowName);
    }

    public static String getHiddenStatusCommentMarker(String workflowName) {
        return String.format("<!-- Build-Reporter/msg-id:workflow-run-status-hidden:%1$s -->", workflowName);
    }

    @Deprecated(forRemoval=true, since="3.7.0")
    public static String getOldActiveStatusCommentMarker(String workflowName) {
        return String.format("<!-- Quarkus-GitHub-Bot/msg-id:workflow-run-status-active:%1$s -->", workflowName);
    }

    public static Map<String, GHArtifact> getBuildReportsArtifacts(List<GHArtifact> artifacts, long runAttempt) {
        TreeMap<String, GHArtifact> mappedArtifacts = new TreeMap<String, GHArtifact>();
        for (GHArtifact artifact : artifacts) {
            Matcher matcher = BUILD_REPORTS_ARTIFACT_NAME_PATTERN.matcher(artifact.getName());
            if (!matcher.matches()) continue;
            String artifactRunAttempt = matcher.group(1);
            if (artifactRunAttempt != null) {
                if (runAttempt != Long.parseLong(artifactRunAttempt)) continue;
                mappedArtifacts.put(matcher.group(2), artifact);
                continue;
            }
            mappedArtifacts.put(matcher.group(2), artifact);
        }
        return mappedArtifacts;
    }

    public static boolean matchesNewBuildReportsArtifactNamePattern(String artifactName) {
        Matcher matcher = BUILD_REPORTS_ARTIFACT_NAME_PATTERN.matcher(artifactName);
        return matcher.matches() && matcher.group(1) != null;
    }

    private WorkflowUtils() {
    }
}

