/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.devtools.commands.ListCategories;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.QuarkusProjectMojoBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list-categories", requiresProject=false)
public class ListCategoriesMojo
extends QuarkusProjectMojoBase {
    private static final String DEFAULT_FORMAT = "concise";
    @Parameter(property="format", defaultValue="concise")
    protected String format;

    @Override
    public void doExecute(QuarkusProject quarkusProject, MessageWriter log) throws MojoExecutionException {
        try {
            ListCategories listExtensions = new ListCategories(quarkusProject).format(this.format);
            listExtensions.execute();
            if (DEFAULT_FORMAT.equalsIgnoreCase(this.format)) {
                log.info("");
                log.info("To get more information, append `%s` to your command line.", new Object[]{"-Dformat=full"});
            }
            log.info("");
            log.info("To list extensions in given category, use:\n%s", new Object[]{"`./mvnw quarkus:list-extensions -Dcategory=\"categoryId\"`"});
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to list extension categories", e);
        }
    }
}

