/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.handlers.UpdateCommandHandler;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.QuarkusProjectStateMojoBase;
import io.quarkus.registry.RegistryResolutionException;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update", requiresProject=true)
public class UpdateMojo
extends QuarkusProjectStateMojoBase {
    @Parameter(property="recommendedState")
    boolean recommendedState;
    @Parameter(property="rectify")
    boolean rectify;

    @Override
    protected void validateParameters() throws MojoExecutionException {
        this.getLog().warn((CharSequence)"quarkus:update goal is experimental, its options and output might change in future versions");
        super.validateParameters();
    }

    @Override
    protected void processProjectState(QuarkusProject quarkusProject) throws MojoExecutionException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("latest-catalog", this.getExtensionCatalogResolver().resolveExtensionCatalog());
        }
        catch (RegistryResolutionException e) {
            throw new MojoExecutionException("Failed to resolve the latest Quarkus extension catalog from the configured extension registries", (Exception)((Object)e));
        }
        params.put("app-model", this.resolveApplicationModel());
        params.put("log-recommended-state", this.recommendedState);
        params.put("log-state-per-module", this.perModule);
        params.put("rectify", this.rectify);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(quarkusProject, params);
        try {
            new UpdateCommandHandler().execute(invocation);
        }
        catch (QuarkusCommandException e) {
            throw new MojoExecutionException("Failed to resolve the available updates", (Exception)((Object)e));
        }
    }
}

