/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.kafka.producer;

import io.quarkus.qe.kafka.model.LoginAttempt;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.kafka.Record;
import io.vertx.core.json.Json;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

@ApplicationScoped
public class LoginEventsProducer {
    private static final int SEND_EVENT_EVERY_MILLIS = 1000;
    @ConfigProperty(name="producer.httpCodes")
    List<Integer> httpCodes;
    @ConfigProperty(name="producer.loginUrls")
    List<String> loginUrls;
    private final Random random = new Random();

    @Outgoing(value="login-http-response-values")
    public Multi<Record<String, String>> generate() {
        return Multi.createFrom().ticks().every(Duration.ofMillis(1000L)).onOverflow().drop().map(tick -> {
            String loginEndpoint = this.getRandomEndpointUrl();
            String loginEndpointEnc = this.encodeId(loginEndpoint);
            Integer httpCode = this.getRandomHttpCode();
            return Record.of((Object)loginEndpointEnc, (Object)Json.encode((Object)new LoginAttempt(loginEndpointEnc, loginEndpoint, httpCode)));
        });
    }

    private String getRandomEndpointUrl() {
        return this.loginUrls.get(this.random.nextInt(this.loginUrls.size()));
    }

    private Integer getRandomHttpCode() {
        return this.httpCodes.get(this.random.nextInt(this.httpCodes.size()));
    }

    private String encodeId(String id) {
        return Base64.getEncoder().encodeToString(id.getBytes());
    }
}

