/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.database.mysql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    public static final int UNPROCESSABLE_ENTITY = 422;

    public Response toResponse(ConstraintViolationException exception) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode errors = mapper.createArrayNode();
        for (ConstraintViolation constraintViolation : exception.getConstraintViolations()) {
            errors.addObject().put("path", constraintViolation.getPropertyPath().toString()).put("message", constraintViolation.getMessage());
        }
        return Response.status((int)422).type("application/json").entity((Object)mapper.createObjectNode().put("code", 422).set("error", (JsonNode)errors)).build();
    }
}

