/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.database.oracle;

import io.quarkus.panache.common.Sort;
import io.quarkus.qe.database.oracle.Book;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/book")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class BookResource {
    @GET
    public List<Book> getAll() {
        return Book.listAll((Sort)Sort.by((String)"title"));
    }

    @GET
    @Path(value="/{id}")
    public Book get(@PathParam(value="id") Long id) {
        Book book = (Book)Book.findById((Object)id);
        if (book == null) {
            throw new NotFoundException("book '" + id + "' not found");
        }
        return book;
    }

    @POST
    @Transactional
    public Response create(@Valid Book book) {
        if (book.id != null) {
            throw new ClientErrorException("unexpected ID in request", 422);
        }
        book.persist();
        return Response.ok((Object)((Object)book)).status(Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/{id}")
    @Transactional
    public Book update(@PathParam(value="id") Long id, @Valid Book newBook) {
        Book book = (Book)Book.findById((Object)id);
        if (book == null) {
            throw new NotFoundException("book '" + id + "' not found");
        }
        book.title = newBook.title;
        book.author = newBook.author;
        return book;
    }

    @DELETE
    @Path(value="/{id}")
    @Transactional
    public Response delete(@PathParam(value="id") Long id) {
        Book book = (Book)Book.findById((Object)id);
        if (book == null) {
            throw new NotFoundException("book '" + id + "' not found");
        }
        book.delete();
        return Response.noContent().build();
    }
}

