/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.kafka.consumer;

import io.quarkus.qe.kafka.StockPrice;
import io.quarkus.qe.kafka.status;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.core.AbstractVerticle;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.jboss.logging.Logger;

@ApplicationScoped
public class KStockPriceConsumer
extends AbstractVerticle {
    private static final Logger LOG = Logger.getLogger(KStockPriceConsumer.class);
    @Inject
    @Channel(value="sink-stock-price")
    @OnOverflow(value=OnOverflow.Strategy.DROP)
    Emitter<StockPrice> emitter;

    public Uni<Void> asyncStart() {
        LOG.info((Object)"Verticle KStockPriceConsumer Up! (does nothing)");
        return Uni.createFrom().voidItem();
    }

    @Incoming(value="channel-stock-price")
    @Acknowledgment(value=Acknowledgment.Strategy.POST_PROCESSING)
    @Outgoing(value="stock-monitor")
    @Broadcast
    public String process(StockPrice next) {
        next.setStatus(status.COMPLETED);
        LOG.debugv("CONSUMER -> ID: {0}, PRICE: {1}", (Object)next.getId(), (Object)next.getPrice());
        this.emitter.send((Object)next).whenComplete(this.handlerEmitterResponse(KStockPriceConsumer.class.getName()));
        return next.getId() + "-" + next.getPrice() + "-" + next.getStatus();
    }

    private BiConsumer<Void, Throwable> handlerEmitterResponse(String owner) {
        return (success, failure) -> {
            if (failure != null) {
                LOG.info((Object)String.format("D'oh! %s", failure.getMessage()));
            }
        };
    }
}

