/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.Action;
import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ManagedResourceBuilder;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.ServiceListener;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.logging.Log;
import io.quarkus.test.utils.AwaitilityUtils;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.LogsVerifier;
import io.quarkus.test.utils.PropertiesUtils;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;

public class BaseService<T extends Service>
implements Service {
    public static final String SERVICE_STARTUP_TIMEOUT = "startup.timeout";
    public static final Duration SERVICE_STARTUP_TIMEOUT_DEFAULT = Duration.ofMinutes(5L);
    private static final String SERVICE_STARTUP_CHECK_POLL_INTERVAL = "startup.check-poll-interval";
    private static final Duration SERVICE_STARTUP_CHECK_POLL_INTERVAL_DEFAULT = Duration.ofSeconds(2L);
    private final ServiceLoader<ServiceListener> listeners = ServiceLoader.load(ServiceListener.class);
    private final List<Action> onPreStartActions = new LinkedList<Action>();
    private final List<Action> onPostStartActions = new LinkedList<Action>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final List<Runnable> futureProperties = new LinkedList<Runnable>();
    private ManagedResource managedResource;
    private String serviceName;
    private Configuration configuration;
    private ServiceContext context;
    private boolean autoStart = true;

    @Override
    public String getScenarioId() {
        return this.context.getScenarioId();
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public String getDisplayName() {
        return this.managedResource.getDisplayName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isAutoStart() {
        return this.autoStart;
    }

    public T onPreStart(Action action) {
        this.onPreStartActions.add(action);
        return (T)this;
    }

    public T onPostStart(Action action) {
        this.onPostStartActions.add(action);
        return (T)this;
    }

    public T setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        return (T)this;
    }

    public T withProperties(String ... propertiesFiles) {
        this.properties.clear();
        Stream.of(propertiesFiles).map(PropertiesUtils::toMap).forEach(this.properties::putAll);
        return (T)this;
    }

    public T withProperty(String key, String value) {
        this.properties.put(key, value);
        return (T)this;
    }

    public T withProperty(String key, Supplier<String> value) {
        this.futureProperties.add(() -> this.properties.put(key, (String)value.get()));
        return (T)this;
    }

    @Override
    public boolean isRunning() {
        Log.debug(this, "Checking if resource is running", new Object[0]);
        if (this.managedResource == null) {
            Log.debug(this, "Resource is not running", new Object[0]);
            return false;
        }
        Log.debug(this, "Resource is running", new Object[0]);
        return this.managedResource.isRunning();
    }

    public String getHost() {
        return this.getHost(Protocol.HTTP);
    }

    public String getHost(Protocol protocol) {
        return this.managedResource.getHost(protocol);
    }

    public Integer getPort() {
        return this.getPort(Protocol.HTTP);
    }

    public Integer getPort(Protocol protocol) {
        return this.managedResource.getPort(protocol);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public List<String> getLogs() {
        return new ArrayList<String>(this.managedResource.logs());
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        Log.debug(this, "Starting service (%s)", this.getDisplayName());
        this.onPreStartActions.forEach(a -> a.handle(this));
        this.doStart();
        this.waitUntilServiceIsStarted();
        this.onPostStartActions.forEach(a -> a.handle(this));
        Log.info(this, "Service started (%s)", this.getDisplayName());
    }

    private void doStart() {
        try {
            this.managedResource.start();
            this.listeners.forEach(ext -> ext.onServiceStarted(this.context));
        }
        catch (Exception ex) {
            this.listeners.forEach(ext -> ext.onServiceError(this.context, ex));
            throw ex;
        }
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        Log.debug(this, "Stopping service (%s)", this.getDisplayName());
        this.listeners.forEach(ext -> ext.onServiceStopped(this.context));
        this.managedResource.stop();
        Log.info(this, "Service stopped (%s)", this.getDisplayName());
    }

    @Override
    public ServiceContext register(String serviceName, ScenarioContext context) {
        this.serviceName = serviceName;
        this.configuration = Configuration.load(serviceName);
        this.context = new ServiceContext(this, context);
        this.onPreStart(s -> this.futureProperties.forEach(Runnable::run));
        context.getTestStore().put((Object)serviceName, (Object)this);
        return this.context;
    }

    @Override
    public void init(ManagedResourceBuilder managedResourceBuilder) {
        FileUtils.recreateDirectory(this.context.getServiceFolder());
        this.managedResource = managedResourceBuilder.build(this.context);
    }

    public void restart() {
        this.managedResource.restart();
    }

    @Override
    public LogsVerifier logs() {
        return new LogsVerifier(this);
    }

    protected Path getServiceFolder() {
        return this.context.getServiceFolder();
    }

    protected <U> U getPropertyFromContext(String key) {
        if (this.context == null) {
            Assertions.fail((String)"Service has not been initialized yet. Make sure you invoke this method in the right order.");
        }
        return (U)this.context.get(key);
    }

    private boolean isRunningOrFailed() {
        if (this.managedResource != null && this.managedResource.isFailed()) {
            this.managedResource.stop();
            Assertions.fail((String)"Resource failed to start");
        }
        return this.isRunning();
    }

    private void waitUntilServiceIsStarted() {
        Duration startupCheckInterval = this.getConfiguration().getAsDuration(SERVICE_STARTUP_CHECK_POLL_INTERVAL, SERVICE_STARTUP_CHECK_POLL_INTERVAL_DEFAULT);
        Duration startupTimeout = this.getConfiguration().getAsDuration(SERVICE_STARTUP_TIMEOUT, SERVICE_STARTUP_TIMEOUT_DEFAULT);
        AwaitilityUtils.untilIsTrue(this::isRunningOrFailed, AwaitilityUtils.AwaitilitySettings.using(startupCheckInterval, startupTimeout).doNotIgnoreExceptions().withService(this).timeoutMessage("Service didn't start in %s minutes", startupTimeout));
    }
}

