/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.SilentCssErrorHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import io.quarkus.test.bootstrap.RestService;
import io.quarkus.test.services.DevModeQuarkusApplication;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;

public class DevModeQuarkusService
extends RestService {
    public static final String DEV_UI_PATH = "/q/dev";
    private static final int JAVASCRIPT_WAIT_TIMEOUT_MILLIS = 10000;
    private static final String XPATH_BTN_CLASS = "contains(@class, 'btn')";
    private static final String XPATH_BTN_ON_OFF_CLASS = "contains(@class, 'btnPowerOnOffButton')";
    private static final String CONTINUOUS_TESTING_BTN = "//a[contains(@class, 'btn') and contains(@class, 'btnPowerOnOffButton')]";
    private static final String CONTINUOUS_TESTING_LABEL_DISABLED = "Tests not running";

    public DevModeQuarkusService enableContinuousTesting() {
        HtmlPage webDevUi = this.webDevUiPage();
        if (this.isContinuousTestingBtnDisabled(webDevUi)) {
            this.clickOnElement(this.getContinuousTestingBtn(webDevUi));
        }
        return this;
    }

    public void modifyFile(String file, Function<String, String> modifier) {
        try {
            File targetFile = this.getServiceFolder().resolve(file).toFile();
            String original = FileUtils.readFileToString((File)targetFile, (Charset)StandardCharsets.UTF_8);
            String updated = modifier.apply(original);
            FileUtils.writeStringToFile((File)targetFile, (String)updated, (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            Assertions.fail((String)("Error modifying file. Caused by " + e.getMessage()));
        }
    }

    public void copyFile(String file, String target) {
        try {
            Path sourcePath = Path.of(file, new String[0]);
            File targetPath = this.getServiceFolder().resolve(target).toFile();
            FileUtils.deleteQuietly((File)targetPath);
            FileUtils.copyFile((File)sourcePath.toFile(), (File)targetPath);
            targetPath.setLastModified(System.currentTimeMillis());
        }
        catch (IOException e) {
            Assertions.fail((String)("Error copying file. Caused by " + e.getMessage()));
        }
    }

    @Override
    public void validate(Field field) {
        if (!field.isAnnotationPresent(DevModeQuarkusApplication.class)) {
            Assertions.fail((String)"DevModeQuarkusService service is not annotated with DevModeQuarkusApplication");
        }
    }

    public HtmlElement getContinuousTestingBtn(HtmlPage page) {
        List<HtmlElement> btn = this.getElementsByXPath(page, CONTINUOUS_TESTING_BTN);
        Assertions.assertEquals((int)1, (int)btn.size(), (String)"Should be only one button to enable continuous testing");
        return btn.get(0);
    }

    public boolean isContinuousTestingBtnDisabled(HtmlPage page) {
        HtmlElement btn = this.getContinuousTestingBtn(page);
        return btn.getTextContent().trim().equals(CONTINUOUS_TESTING_LABEL_DISABLED);
    }

    public HtmlPage clickOnElement(HtmlElement elem) {
        try {
            return (HtmlPage)elem.click();
        }
        catch (IOException e) {
            Assertions.fail((String)("Can't click on element. Caused by: " + e.getMessage()));
            return null;
        }
    }

    public List<HtmlElement> getElementsByXPath(HtmlPage htmlPage, String path) {
        return htmlPage.getByXPath(path).stream().filter(elem -> elem instanceof HtmlElement).map(elem -> (HtmlElement)elem).collect(Collectors.toList());
    }

    public HtmlPage webDevUiPage() {
        try {
            HtmlPage page = (HtmlPage)this.webPage(DEV_UI_PATH).refresh();
            this.waitUntilLoaded(page);
            return page;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void waitUntilLoaded(HtmlPage page) {
        page.getEnclosingWindow().getJobManager().waitForJobs(10000L);
    }

    public HtmlPage webPage(String path) {
        try {
            return (HtmlPage)this.webClient().getPage(this.getHost() + ":" + this.getPort() + path);
        }
        catch (IOException e) {
            Assertions.fail((String)("Page with path " + path + " does not exist"));
            return null;
        }
    }

    public WebClient webClient() {
        WebClient webClient = new WebClient(BrowserVersion.CHROME);
        webClient.getCookieManager().clearCookies();
        webClient.getCache().clear();
        webClient.getCache().setMaxSize(0);
        webClient.setCssErrorHandler((CSSErrorHandler)new SilentCssErrorHandler());
        webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        webClient.getOptions().setUseInsecureSSL(true);
        webClient.getOptions().setDownloadImages(false);
        webClient.getOptions().setGeolocationEnabled(false);
        webClient.getOptions().setAppletEnabled(false);
        webClient.getOptions().setCssEnabled(false);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getOptions().setRedirectEnabled(true);
        return webClient;
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

