/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.AnnotationBinding;
import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.LookupService;
import io.quarkus.test.bootstrap.ManagedResourceBuilder;
import io.quarkus.test.bootstrap.RestService;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.ReflectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.LogManager;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;

public class QuarkusScenarioBootstrap
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver,
LifecycleMethodExecutionExceptionHandler,
TestWatcher {
    private static final PropertyLookup CREATE_SERVICE_BY_DEFAULT = new PropertyLookup("generated-service.enabled", Boolean.TRUE.toString());
    private static final String DEFAULT_SERVICE_NAME = "app";
    private final ServiceLoader<AnnotationBinding> bindingsRegistry = ServiceLoader.load(AnnotationBinding.class);
    private final ServiceLoader<ExtensionBootstrap> extensionsRegistry = ServiceLoader.load(ExtensionBootstrap.class);
    private List<Service> services = new ArrayList<Service>();
    private ScenarioContext scenario;
    private List<ExtensionBootstrap> extensions;

    public QuarkusScenarioBootstrap() {
        this.configureLogging();
    }

    public void beforeAll(ExtensionContext context) {
        this.scenario = new ScenarioContext(context);
        Log.info("Scenario ID: '%s'", this.scenario.getId());
        this.extensions = this.initExtensions();
        this.extensions.forEach(ext -> ext.beforeAll(this.scenario));
        ReflectionUtils.findAllFields(context.getRequiredTestClass()).forEach(field -> this.initResourceFromField(context, (Field)field));
        if (this.services.isEmpty() && CREATE_SERVICE_BY_DEFAULT.getAsBoolean().booleanValue()) {
            this.services.add(this.createDefaultService());
        }
        this.services.forEach(service -> this.launchService((Service)service));
    }

    public void afterAll(ExtensionContext context) {
        try {
            ArrayList<Service> servicesToStop = new ArrayList<Service>(this.services);
            Collections.reverse(servicesToStop);
            servicesToStop.forEach(Service::stop);
        }
        finally {
            this.extensions.forEach(ext -> ext.afterAll(this.scenario));
        }
    }

    public void beforeEach(ExtensionContext context) {
        Log.info("## Running test " + context.getParent().map(ctx -> ctx.getDisplayName() + ".").orElse("") + context.getDisplayName(), new Object[0]);
        this.scenario.setMethodTestContext(context);
        this.extensions.forEach(ext -> ext.beforeEach(this.scenario));
        this.services.forEach(service -> {
            if (service.isAutoStart()) {
                service.start();
            }
        });
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.extensions.forEach(ext -> ext.afterEach(this.scenario));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.extensions.stream().anyMatch(ext -> ext.getParameter(parameterContext.getParameter().getType()).isPresent());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.getParameter(parameterContext.getParameter().getName(), parameterContext.getParameter().getType());
    }

    public void handleAfterAllMethodExecutionException(ExtensionContext context, Throwable throwable) {
        this.notifyExtensionsOnError(throwable);
    }

    public void handleAfterEachMethodExecutionException(ExtensionContext context, Throwable throwable) {
        this.notifyExtensionsOnError(throwable);
    }

    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) {
        this.notifyExtensionsOnError(throwable);
    }

    public void testSuccessful(ExtensionContext context) {
        this.extensions.forEach(ext -> ext.onSuccess(this.scenario));
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        this.extensions.forEach(ext -> ext.onError(this.scenario, cause));
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        this.extensions.forEach(ext -> ext.onDisabled(this.scenario, reason));
    }

    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) {
        this.notifyExtensionsOnError(throwable);
    }

    private void launchService(Service service) {
        if (!service.isAutoStart()) {
            Log.debug(service, "Service (%s) auto start is off", service.getDisplayName());
            return;
        }
        Log.info(service, "Initialize service (%s)", service.getDisplayName());
        this.extensions.forEach(ext -> ext.onServiceLaunch(this.scenario, service));
        try {
            service.start();
        }
        catch (Error throwable) {
            this.notifyExtensionsOnError(throwable);
            throw throwable;
        }
    }

    private void notifyExtensionsOnError(Throwable throwable) {
        throwable.printStackTrace();
        this.extensions.forEach(ext -> ext.onError(this.scenario, throwable));
    }

    private void initResourceFromField(ExtensionContext context, Field field) {
        if (field.isAnnotationPresent(LookupService.class)) {
            this.initLookupService(context, field);
        } else if (Service.class.isAssignableFrom(field.getType())) {
            this.initService(context, field);
        } else if (field.isAnnotationPresent(Inject.class)) {
            this.injectDependency(field);
        }
    }

    private void injectDependency(Field field) {
        Object fieldValue = null;
        fieldValue = ScenarioContext.class.equals(field.getType()) ? this.scenario : this.getParameter(field.getName(), field.getType());
        ReflectionUtils.setStaticFieldValue(field, fieldValue);
    }

    private Service initService(ExtensionContext context, Field field) {
        Service service = (Service)ReflectionUtils.getStaticFieldValue(field);
        if (service.isRunning()) {
            return service;
        }
        service.validate(field);
        ManagedResourceBuilder resource = this.getManagedResourceBuilder(field);
        ServiceContext serviceContext = service.register(field.getName(), this.scenario);
        this.extensions.forEach(ext -> ext.updateServiceContext(serviceContext));
        service.init(resource);
        this.services.add(service);
        return service;
    }

    private ManagedResourceBuilder getManagedResourceBuilder(Field field) {
        AnnotationBinding binding = this.bindingsRegistry.stream().map(ServiceLoader.Provider::get).filter(b -> b.isFor(field)).findFirst().orElseThrow(() -> new RuntimeException("Unknown annotation for service"));
        try {
            return binding.createBuilder(field);
        }
        catch (Exception ex) {
            Assertions.fail((String)("Could not create the Managed Resource Builder for " + field.getName() + ". Caused by: " + ex.getMessage()));
            return null;
        }
    }

    private void initLookupService(ExtensionContext context, Field fieldToInject) {
        Optional<Field> fieldService = ReflectionUtils.findAllFields(context.getRequiredTestClass()).stream().filter(field -> field.getName().equals(fieldToInject.getName()) && !field.isAnnotationPresent(LookupService.class)).findAny();
        if (!fieldService.isPresent()) {
            Assertions.fail((String)("Could not lookup service with name " + fieldToInject.getName()));
        }
        Service service = this.initService(context, fieldService.get());
        ReflectionUtils.setStaticFieldValue(fieldToInject, service);
    }

    private Object getParameter(String name, Class<?> clazz) {
        Optional<Object> parameter = this.extensions.stream().map(ext -> ext.getParameter(clazz)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (!parameter.isPresent()) {
            Assertions.fail((String)("Failed to inject: " + name));
        }
        return parameter.get();
    }

    private List<ExtensionBootstrap> initExtensions() {
        ArrayList<ExtensionBootstrap> list = new ArrayList<ExtensionBootstrap>();
        for (ExtensionBootstrap binding : this.extensionsRegistry) {
            if (!binding.appliesFor(this.scenario)) continue;
            list.add(binding);
        }
        return list;
    }

    private Service createDefaultService() {
        try {
            ProdQuarkusApplicationManagedResourceBuilder resource = new ProdQuarkusApplicationManagedResourceBuilder();
            resource.initAppClasses(null);
            RestService service = new RestService();
            ServiceContext serviceContext = service.register(DEFAULT_SERVICE_NAME, this.scenario);
            this.extensions.forEach(ext -> ext.updateServiceContext(serviceContext));
            service.init(resource);
            return service;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void configureLogging() {
        Locale.setDefault(new Locale("en", "EN"));
        try {
            FileUtils.recreateDirectory(Log.LOG_OUTPUT_DIRECTORY);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try (InputStream in = QuarkusScenarioBootstrap.class.getResourceAsStream("/logging.properties");){
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

