/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.BaseService;
import io.quarkus.test.bootstrap.Protocol;
import io.restassured.RestAssured;
import io.restassured.specification.RequestSpecification;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;

public class RestService
extends BaseService<RestService> {
    private static final String BASE_PATH = "/";
    private WebClient webClient;

    public RequestSpecification given() {
        return RestAssured.given().baseUri(this.getHost()).basePath(BASE_PATH).port(this.getPort().intValue());
    }

    public RequestSpecification https() {
        return RestAssured.given().baseUri(this.getHost(Protocol.HTTPS)).basePath(BASE_PATH).port(this.getPort(Protocol.HTTPS).intValue());
    }

    public WebClient mutiny() {
        return this.mutiny(new WebClientOptions());
    }

    public WebClient mutiny(WebClientOptions options) {
        if (this.webClient == null) {
            this.webClient = WebClient.create((Vertx)Vertx.vertx(), (WebClientOptions)options.setDefaultHost(this.getHost().replace("http://", "")).setDefaultPort(this.getPort().intValue()));
        }
        return this.webClient;
    }

    @Override
    public void start() {
        super.start();
        RestAssured.baseURI = this.getHost();
        RestAssured.basePath = BASE_PATH;
        RestAssured.port = this.getPort();
    }
}

