/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.Service;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ServiceContext {
    private final Service owner;
    private final ScenarioContext scenarioContext;
    private final Path serviceFolder;
    private final Map<String, Object> store = new HashMap<String, Object>();

    protected ServiceContext(Service owner, ScenarioContext scenarioContext) {
        this.owner = owner;
        this.scenarioContext = scenarioContext;
        this.serviceFolder = Path.of("target", scenarioContext.getRunningTestClassName(), this.getName());
    }

    public Service getOwner() {
        return this.owner;
    }

    public String getScenarioId() {
        return this.scenarioContext.getId();
    }

    public String getName() {
        return this.owner.getName();
    }

    public ScenarioContext getScenarioContext() {
        return this.scenarioContext;
    }

    public ExtensionContext getTestContext() {
        return this.scenarioContext.getTestContext();
    }

    public Path getServiceFolder() {
        return this.serviceFolder;
    }

    public void put(String key, Object value) {
        this.store.put(key, value);
    }

    public <T> T get(String key) {
        return (T)this.store.get(key);
    }
}

