/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.configuration;

import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class Configuration {
    private static final String GLOBAL_PROPERTIES = System.getProperty("ts.test.resources.file.location", "global.properties");
    private static final String TEST_PROPERTIES = "test.properties";
    private static final String PREFIX_TEMPLATE = "ts.%s.";
    private static final String GLOBAL_SCOPE = "global";
    private final Map<String, String> properties;

    private Configuration(Map<String, String> properties) {
        this.properties = properties;
    }

    public List<String> getAsList(String property) {
        String value = this.get(property);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Stream.of(value.split(",")).collect(Collectors.toList());
    }

    public Duration getAsDuration(String property, Duration defaultValue) {
        Object value = this.get(property);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        if (Character.isDigit(((String)value).charAt(0))) {
            value = "PT" + (String)value;
        }
        return Duration.parse((CharSequence)value);
    }

    public Double getAsDouble(String property, double defaultValue) {
        String value = this.get(property);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public String get(String property) {
        return this.properties.get(property);
    }

    public String getOrDefault(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public boolean isTrue(String property) {
        return this.is(property, Boolean.TRUE.toString());
    }

    public boolean is(String property, String expected) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.properties.get(property), (CharSequence)expected);
    }

    public static Configuration load() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(Configuration.loadPropertiesFrom(GLOBAL_PROPERTIES, GLOBAL_SCOPE));
        properties.putAll(Configuration.loadPropertiesFromSystemProperties(GLOBAL_SCOPE));
        properties.putAll(Configuration.loadPropertiesFrom(TEST_PROPERTIES, GLOBAL_SCOPE));
        return new Configuration(properties);
    }

    public static Configuration load(String serviceName) {
        Configuration configuration = Configuration.load();
        configuration.properties.putAll(Configuration.loadPropertiesFrom(TEST_PROPERTIES, serviceName));
        configuration.properties.putAll(Configuration.loadPropertiesFromSystemProperties(serviceName));
        return configuration;
    }

    private static Map<String, String> loadPropertiesFromSystemProperties(String scope) {
        return Configuration.loadPropertiesFrom(System.getProperties(), scope);
    }

    private static Map<String, String> loadPropertiesFrom(String propertiesFile, String scope) {
        Map<String, String> map;
        block8: {
            InputStream input = Configuration.class.getClassLoader().getResourceAsStream(propertiesFile);
            try {
                Properties prop = new Properties();
                prop.load(input);
                map = Configuration.loadPropertiesFrom(prop, scope);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return Collections.emptyMap();
                }
            }
            input.close();
        }
        return map;
    }

    private static Map<String, String> loadPropertiesFrom(Properties prop, String scope) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String prefix = String.format(PREFIX_TEMPLATE, scope);
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            properties.put(key.replace(prefix, ""), (String)entry.getValue());
        }
        return properties;
    }
}

