/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.configuration;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;

public class PropertyLookup {
    private static final Configuration GLOBAL = Configuration.load();
    private final String propertyKey;
    private final String defaultValue;

    public PropertyLookup(String propertyKey) {
        this(propertyKey, "");
    }

    public PropertyLookup(String propertyKey, String defaultValue) {
        this.propertyKey = propertyKey;
        this.defaultValue = defaultValue;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String get(ServiceContext service) {
        String value = (String)service.get(this.propertyKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = service.getOwner().getConfiguration().get(this.propertyKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = service.getOwner().getProperties().get(value);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return this.get();
    }

    public String get() {
        String value = GLOBAL.get(this.propertyKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = System.getProperty(this.propertyKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return this.defaultValue;
    }

    public Boolean getAsBoolean() {
        String value = this.get();
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public Integer getAsInteger() {
        String value = this.get();
        return Integer.parseInt(value);
    }
}

