/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.logging;

import io.quarkus.test.logging.Log;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;

public class FileLoggingHandler
extends LoggingHandler {
    private final File file;
    private String printedContent;

    public FileLoggingHandler(File input) {
        this.file = input;
    }

    @Override
    protected synchronized void handle() {
        if (this.file.exists()) {
            String newContent = FileUtils.loadFile(this.file);
            this.onStringDifference(newContent, this.printedContent);
            this.printedContent = newContent;
        }
    }

    @Override
    public List<String> logs() {
        try {
            return Files.readAllLines(this.file.toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            Log.warn("Exception reading file log file", e);
            return super.logs();
        }
    }
}

