/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.logging;

import io.quarkus.test.logging.Log;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.maven.shared.utils.StringUtils;

public abstract class LoggingHandler
implements Closeable {
    private static final long TIMEOUT_IN_MILLIS = 4000L;
    private Thread innerThread;
    private List<String> logs = new CopyOnWriteArrayList<String>();
    private boolean running = false;

    protected abstract void handle();

    public void startWatching() {
        this.logs.clear();
        this.running = true;
        this.innerThread = new Thread(this::run);
        this.innerThread.setDaemon(true);
        this.innerThread.start();
    }

    public void stopWatching() {
        this.flush();
        this.running = false;
        this.logs.clear();
        if (this.innerThread != null) {
            try {
                this.innerThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<String> logs() {
        return Collections.unmodifiableList(this.logs);
    }

    public boolean logsContains(String expected) {
        return this.logs().stream().anyMatch(line -> line.contains(expected));
    }

    public void flush() {
        this.handle();
    }

    @Override
    public void close() {
        if (this.running) {
            this.stopWatching();
        }
    }

    protected void run() {
        while (this.running) {
            try {
                this.handle();
                Thread.sleep(4000L);
            }
            catch (Exception exception) {}
        }
    }

    protected void onLine(String line) {
        this.logs.add(line);
        if (this.isLogEnabled()) {
            this.logInfo(line);
        }
    }

    protected void logInfo(String line) {
        Log.info(line, new Object[0]);
    }

    protected void onLines(String lines) {
        Stream.of(lines.split("\\r?\\n")).filter(StringUtils::isNotEmpty).forEach(this::onLine);
    }

    protected void onStringDifference(String newLines, String oldLines) {
        if (StringUtils.isNotEmpty((String)oldLines)) {
            this.onLines(StringUtils.replace((String)newLines, (String)oldLines, (String)""));
        } else {
            this.onLines(newLines);
        }
    }

    protected boolean isLogEnabled() {
        return true;
    }
}

