/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.metrics;

import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.metrics.GaugesTypes;
import io.quarkus.test.metrics.HistogramTypes;
import io.quarkus.test.metrics.MetricsExporterService;
import io.quarkus.test.metrics.QuarkusGauges;
import io.quarkus.test.metrics.QuarkusHistograms;
import io.quarkus.test.metrics.QuarkusLabels;
import io.quarkus.test.scenarios.QuarkusScenario;
import java.util.Optional;

public class MetricsExtensionBootstrap
implements ExtensionBootstrap {
    private static final PropertyLookup METRICS_EXTENSION_ENABLED_PROPERTY = new PropertyLookup("metrics.enabled", "true");
    private static final PropertyLookup METRICS_PUSH_AFTER_EACH_TEST = new PropertyLookup("metrics.push-after-each-test", "false");
    private final boolean extensionEnabled = METRICS_EXTENSION_ENABLED_PROPERTY.getAsBoolean();
    private QuarkusLabels metricCommonLabels;
    private QuarkusGauges quarkusGauges;
    private QuarkusHistograms quarkusHistograms;

    public MetricsExtensionBootstrap() {
        if (this.extensionEnabled) {
            MetricsExporterService metricsExporterService = new MetricsExporterService();
            this.metricCommonLabels = new QuarkusLabels();
            this.quarkusGauges = new QuarkusGauges(metricsExporterService);
            this.quarkusHistograms = new QuarkusHistograms(metricsExporterService);
        }
    }

    @Override
    public boolean appliesFor(ScenarioContext context) {
        return this.extensionEnabled && context.isAnnotationPresent(QuarkusScenario.class);
    }

    @Override
    public void beforeAll(ScenarioContext context) {
        this.quarkusHistograms.startDurationBeforeAll(HistogramTypes.SCENARIO_TEST_TIME_SEC);
        this.metricCommonLabels.addModuleNameLabel();
        this.metricCommonLabels.addScenarioNameLabel(context.getRunningTestClassName());
        this.metricCommonLabels.markModuleAsSuccess();
    }

    @Override
    public void beforeEach(ScenarioContext context) {
        this.quarkusGauges.increment(GaugesTypes.TESTS_TOTAL);
        this.pushAfterEachTestIfEnabled();
    }

    @Override
    public void onSuccess(ScenarioContext context) {
        this.quarkusGauges.increment(GaugesTypes.TESTS_SUCCEED);
        this.pushAfterEachTestIfEnabled();
    }

    @Override
    public void onError(ScenarioContext context, Throwable throwable) {
        this.quarkusGauges.increment(GaugesTypes.TESTS_FAILED);
        this.metricCommonLabels.markModuleAsFailed();
        this.pushAfterEachTestIfEnabled();
    }

    @Override
    public void onDisabled(ScenarioContext context, Optional<String> reason) {
        this.quarkusGauges.increment(GaugesTypes.TESTS_IGNORE);
        this.pushAfterEachTestIfEnabled();
    }

    @Override
    public void afterAll(ScenarioContext context) {
        this.quarkusHistograms.stopDurationAfterAll(HistogramTypes.SCENARIO_TEST_TIME_SEC);
        this.quarkusHistograms.push(this.metricCommonLabels);
        if (!METRICS_PUSH_AFTER_EACH_TEST.getAsBoolean().booleanValue()) {
            this.quarkusGauges.push(this.metricCommonLabels);
        }
    }

    private void pushAfterEachTestIfEnabled() {
        if (METRICS_PUSH_AFTER_EACH_TEST.getAsBoolean().booleanValue()) {
            this.quarkusGauges.push(this.metricCommonLabels);
        }
    }
}

