/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.metrics;

import io.quarkus.test.metrics.GaugesTypes;
import io.quarkus.test.metrics.MetricsExporterService;
import io.quarkus.test.metrics.QuarkusLabels;

public class QuarkusGauges {
    private final MetricsExporterService exporter;

    public QuarkusGauges(MetricsExporterService exporter) {
        this.exporter = exporter;
    }

    public void increment(GaugesTypes gaugesTypes) {
        int currentGaugeValue = this.getCurrentGaugeValue(gaugesTypes.getCode());
        this.exporter.commit(gaugesTypes.getCode(), currentGaugeValue + 1);
    }

    public void push(QuarkusLabels labels) {
        this.exporter.push(labels.getLabelsBucket());
    }

    private int getCurrentGaugeValue(String gaugeBucketID) {
        return this.exporter.getMetricValue(gaugeBucketID, 0);
    }
}

