/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.metrics;

import io.quarkus.test.utils.TestExecutionProperties;
import java.util.HashMap;
import java.util.Map;

public class QuarkusLabels {
    public static final String MODULE_STATUS = "module_status";
    public static final String MODULE_NAME = "module_name";
    public static final String SCENARIO_NAME = "scenario_name";
    private static final String MODULES_SUCCESS = "module_success";
    private static final String MODULES_FAIL = "module_fail";
    private static final String PLATFORM_LABEL_NAME = "execution_platform";
    private static final String PLUGIN_VERSION_LABEL_NAME = "execution_quarkus_version";
    private static final String SERVICE_NAME_LABEL_NAME = "execution_service_name";
    private static final String BUILD_NUMBER_LABEL_NAME = "execution_build_number";
    private final Map<String, String> labelsBucket = new HashMap<String, String>();

    public QuarkusLabels() {
        this.labelsBucket.put(BUILD_NUMBER_LABEL_NAME, TestExecutionProperties.getBuildNumber());
        this.labelsBucket.put(PLUGIN_VERSION_LABEL_NAME, TestExecutionProperties.getVersionNumber());
        this.labelsBucket.put(SERVICE_NAME_LABEL_NAME, TestExecutionProperties.getServiceName());
        this.addPlatformLabel();
    }

    private void addPlatformLabel() {
        if (TestExecutionProperties.isOpenshiftPlatform()) {
            this.labelsBucket.put(PLATFORM_LABEL_NAME, "ocp");
        }
        if (TestExecutionProperties.isKubernetesPlatform()) {
            this.labelsBucket.put(PLATFORM_LABEL_NAME, "k8s");
        }
        if (TestExecutionProperties.isBareMetalPlatform()) {
            this.labelsBucket.put(PLATFORM_LABEL_NAME, "bare-metal");
        }
    }

    public void addLabel(String labelName, String labelValue) {
        if (!this.labelsBucket.containsKey(labelName)) {
            this.labelsBucket.put(labelName, labelValue);
        }
    }

    private String getModuleName() {
        String userDirectory = System.getProperty("user.dir");
        return userDirectory.substring(userDirectory.lastIndexOf("/") + 1);
    }

    public void addModuleNameLabel() {
        this.addLabel(MODULE_NAME, this.getModuleName());
    }

    public void addScenarioNameLabel(String scenarioName) {
        this.addLabel(SCENARIO_NAME, scenarioName);
    }

    public void markModuleAsSuccess() {
        this.getLabelsBucket().put(MODULE_STATUS, MODULES_SUCCESS);
    }

    public void markModuleAsFailed() {
        this.getLabelsBucket().put(MODULE_STATUS, MODULES_FAIL);
    }

    public Map<String, String> getLabelsBucket() {
        return this.labelsBucket;
    }
}

