/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.metrics.exporters;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.exporter.PushGateway;
import io.quarkus.test.metrics.exporters.MetricsExporter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PrometheusMetricsExporter
implements MetricsExporter {
    private final PushGateway prometheusClient;
    private final CollectorRegistry defaultRegistry;
    private final Map<String, Gauge> registeredGaugeMetrics = new HashMap<String, Gauge>();
    private final Map<String, Histogram> registeredHistogramMetrics = new HashMap<String, Histogram>();

    public PrometheusMetricsExporter(String prometheusHttpEndpoint) {
        this.prometheusClient = new PushGateway(prometheusHttpEndpoint);
        this.defaultRegistry = new CollectorRegistry();
    }

    @Override
    public String type() {
        return "prometheus";
    }

    @Override
    public void commit(String metricId, Object metricValue) {
        if (metricValue instanceof Integer) {
            this.commitGauge(metricId, (Integer)metricValue);
        } else if (metricValue instanceof Long) {
            this.commitHistogram(metricId, (Long)metricValue);
        }
    }

    @Override
    public void push(String serviceName, Map<String, String> labels) throws IOException {
        this.prometheusClient.pushAdd(this.defaultRegistry, serviceName, labels);
    }

    private void commitGauge(String metricId, int metricValue) {
        Gauge gauge = this.registeredGaugeMetrics.get(metricId);
        if (gauge == null) {
            gauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(metricId)).help("Module gauge")).register(this.defaultRegistry);
            this.registeredGaugeMetrics.put(metricId, gauge);
        }
        gauge.set((double)metricValue);
    }

    private void commitHistogram(String metricId, long metricValue) {
        Histogram histogram = this.registeredHistogramMetrics.get(metricId);
        if (histogram == null) {
            histogram = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(metricId)).help("Test latency in seconds.")).register(this.defaultRegistry);
            this.registeredHistogramMetrics.put(metricId, histogram);
        }
        histogram.observe((double)metricValue);
    }
}

