/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.scenarios.annotations;

import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class CheckIfSystemPropertyCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        String systemProperty = this.getSystemPropertyName(context);
        String actual = System.getProperty(systemProperty);
        if (this.checkEnableCondition(context, actual)) {
            return ConditionEvaluationResult.enabled((String)String.format("System property [%s] matches the condition", systemProperty));
        }
        return ConditionEvaluationResult.disabled((String)String.format("System property [%s] does not apply condition", systemProperty));
    }

    protected abstract boolean checkEnableCondition(ExtensionContext var1, String var2);

    protected abstract String getSystemPropertyName(ExtensionContext var1);
}

