/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.scenarios.annotations;

import io.quarkus.builder.Version;
import io.quarkus.test.scenarios.annotations.DisabledOnQuarkusSnapshot;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledOnQuarkusSnapshotCondition
implements ExecutionCondition {
    private static final String QUARKUS_SNAPSHOT_VERSION = "999-SNAPSHOT";
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisabledOnQuarkusSnapshot is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        return AnnotationUtils.findAnnotation((Optional)element, DisabledOnQuarkusSnapshot.class).stream().filter(annotation -> DisabledOnQuarkusSnapshotCondition.isQuarkusSnapshotVersion()).findAny().map(this::testIsDisabled).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult testIsDisabled(DisabledOnQuarkusSnapshot disabledOnQuarkus) {
        return ConditionEvaluationResult.disabled((String)("Disabled on Quarkus snapshot (reason: " + disabledOnQuarkus.reason() + ")"));
    }

    public static boolean isQuarkusSnapshotVersion() {
        return QUARKUS_SNAPSHOT_VERSION.equals(Version.getVersion());
    }
}

