/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.scenarios.annotations;

import io.quarkus.builder.Version;
import io.quarkus.test.scenarios.annotations.EnabledOnQuarkusVersion;
import java.util.Optional;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class EnabledOnQuarkusVersionCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnabledOnQuarkusVersion is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        return AnnotationUtils.findRepeatableAnnotations((Optional)element, EnabledOnQuarkusVersion.class).stream().filter(this::isDisabledOnCurrentQuarkusVersion).findAny().map(this::testIsDisabled).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult testIsDisabled(EnabledOnQuarkusVersion disabledOnQuarkus) {
        return ConditionEvaluationResult.disabled((String)("Disabled on Quarkus version (reason: " + disabledOnQuarkus.reason() + ")"));
    }

    private boolean isDisabledOnCurrentQuarkusVersion(EnabledOnQuarkusVersion enabledOnQuarkus) {
        String quarkusVersion;
        Pattern pattern = Pattern.compile(enabledOnQuarkus.version());
        return !pattern.matcher(quarkusVersion = Version.getVersion()).matches();
    }
}

