/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.services.quarkus.GitRepositoryQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.ProdLocalhostQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.GitUtils;
import io.quarkus.test.utils.MavenUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GitRepositoryLocalhostQuarkusApplicationManagedResource
extends ProdLocalhostQuarkusApplicationManagedResource {
    private static final String QUARKUS_VERSION = "quarkus.version";
    private static final String QUARKUS_PLUGIN_VERSION = "quarkus-plugin.version";
    private static final String QUARKUS_VERSION_VALUE = "${quarkus.platform.version}";
    private final GitRepositoryQuarkusApplicationManagedResourceBuilder model;

    public GitRepositoryLocalhostQuarkusApplicationManagedResource(GitRepositoryQuarkusApplicationManagedResourceBuilder model) {
        super(model);
        this.model = model;
    }

    @Override
    public void onPreBuild() {
        super.onPreBuild();
        GitUtils.cloneRepository(this.model.getContext(), this.model.getGitRepository());
        if (StringUtils.isNotEmpty((CharSequence)this.model.getGitBranch())) {
            GitUtils.checkoutBranch(this.model.getContext(), this.model.getGitBranch());
        }
        String[] mvnArgs = StringUtils.split((String)this.model.getMavenArgs(), (String)" ");
        List<String> effectiveProperties = this.getEffectivePropertiesForGitRepository(Arrays.asList(mvnArgs));
        MavenUtils.build(this.model.getContext(), this.getApplicationFolder(), effectiveProperties);
    }

    @Override
    protected Path getApplicationFolder() {
        Path appFolder = this.model.getContext().getServiceFolder();
        if (StringUtils.isNotEmpty((CharSequence)this.model.getContextDir())) {
            appFolder = appFolder.resolve(this.model.getContextDir());
        }
        return appFolder;
    }

    @Override
    protected List<String> prepareCommand(List<String> systemProperties) {
        List<String> effectiveProperties = this.getEffectivePropertiesForGitRepository(systemProperties);
        if (this.model.isDevMode()) {
            return MavenUtils.devModeMavenCommand(this.model.getContext(), effectiveProperties);
        }
        return super.prepareCommand(effectiveProperties);
    }

    @Override
    protected LaunchMode getLaunchMode() {
        if (this.model.isDevMode()) {
            return LaunchMode.DEV;
        }
        return super.getLaunchMode();
    }

    private List<String> getEffectivePropertiesForGitRepository(List<String> properties) {
        LinkedList<String> effectiveProperties = new LinkedList<String>(properties);
        effectiveProperties.add(MavenUtils.withProperty(QUARKUS_VERSION, QUARKUS_VERSION_VALUE));
        effectiveProperties.add(MavenUtils.withProperty(QUARKUS_PLUGIN_VERSION, QUARKUS_VERSION_VALUE));
        return effectiveProperties;
    }
}

