/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.logging.FileServiceLoggingHandler;
import io.quarkus.test.logging.Log;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.quarkus.test.utils.ProcessBuilderProvider;
import io.quarkus.test.utils.ProcessUtils;
import io.quarkus.test.utils.SocketUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public abstract class LocalhostQuarkusApplicationManagedResource
extends QuarkusManagedResource {
    private static final String LOG_OUTPUT_FILE = "out.log";
    private final QuarkusApplicationManagedResourceBuilder model;
    private File logOutputFile;
    private Process process;
    private LoggingHandler loggingHandler;
    private int assignedHttpPort;
    private int assignedHttpsPort;
    private int assignedGrpcPort;

    public LocalhostQuarkusApplicationManagedResource(QuarkusApplicationManagedResourceBuilder model) {
        super(model.getContext());
        this.model = model;
        this.logOutputFile = new File(model.getContext().getServiceFolder().resolve(LOG_OUTPUT_FILE).toString());
    }

    protected abstract List<String> prepareCommand(List<String> var1);

    @Override
    public void start() {
        if (this.process != null && this.process.isAlive()) {
            return;
        }
        try {
            this.assignPorts();
            List<String> command = this.prepareCommand(this.getPropertiesForCommand());
            Log.info("Running command: %s", String.join((CharSequence)" ", command));
            this.process = ProcessBuilderProvider.command(command).redirectErrorStream(true).redirectOutput(this.logOutputFile).directory(this.getApplicationFolder().toFile()).start();
            this.loggingHandler = new FileServiceLoggingHandler(this.model.getContext().getOwner(), this.logOutputFile);
            this.loggingHandler.startWatching();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        ProcessUtils.destroy(this.process);
    }

    @Override
    public String getHost(Protocol protocol) {
        this.validateProtocol(protocol);
        return protocol.getValue() + "://localhost";
    }

    @Override
    public int getPort(Protocol protocol) {
        this.validateProtocol(protocol);
        if (protocol == Protocol.HTTPS) {
            return this.assignedHttpsPort;
        }
        if (protocol == Protocol.GRPC) {
            return this.assignedGrpcPort;
        }
        return this.assignedHttpPort;
    }

    @Override
    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    @Override
    public void restart() {
        this.stop();
        if (this.model.containsBuildProperties()) {
            this.model.build();
        }
        this.start();
    }

    @Override
    public boolean isRunning() {
        return this.process != null && this.process.isAlive() && super.isRunning();
    }

    @Override
    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    protected Path getApplicationFolder() {
        return this.model.getContext().getServiceFolder();
    }

    private void assignPorts() {
        this.assignedHttpPort = this.getOrAssignPortByProperty("quarkus.http.port");
        if (this.model.isSslEnabled()) {
            this.assignedHttpsPort = this.getOrAssignPortByProperty("quarkus.http.ssl-port");
        }
        if (this.model.isGrpcEnabled()) {
            this.assignedGrpcPort = this.getOrAssignPortByProperty("quarkus.grpc.server.port");
        }
    }

    private int getOrAssignPortByProperty(String property) {
        String port = this.model.getContext().getOwner().getProperties().get(property);
        if (StringUtils.isEmpty((CharSequence)port)) {
            return SocketUtils.findAvailablePort();
        }
        return Integer.parseInt(port);
    }

    private List<String> getPropertiesForCommand() {
        HashMap<String, String> runtimeProperties = new HashMap<String, String>(this.model.getContext().getOwner().getProperties());
        runtimeProperties.putIfAbsent("quarkus.http.port", "" + this.assignedHttpPort);
        if (this.model.isSslEnabled()) {
            runtimeProperties.putIfAbsent("quarkus.http.ssl-port", "" + this.assignedHttpsPort);
        }
        if (this.model.isGrpcEnabled()) {
            runtimeProperties.putIfAbsent("quarkus.grpc.server.port", "" + this.assignedGrpcPort);
        }
        return runtimeProperties.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
    }

    private void validateProtocol(Protocol protocol) {
        if (protocol == Protocol.HTTPS && !this.model.isSslEnabled()) {
            Assertions.fail((String)"SSL was not enabled. Use: `@QuarkusApplication(ssl = true)`");
        } else if (protocol == Protocol.GRPC && !this.model.isGrpcEnabled()) {
            Assertions.fail((String)"gRPC was not enabled. Use: `@QuarkusApplication(grpc = true)`");
        }
    }
}

