/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.services.QuarkusApplication;
import io.quarkus.test.services.quarkus.ProdLocalhostQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBinding;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.OS;

public class ProdQuarkusApplicationManagedResourceBuilder
extends QuarkusApplicationManagedResourceBuilder {
    protected static final String TARGET = "target";
    private static final String NATIVE_RUNNER = "-runner";
    private static final String EXE = ".exe";
    private static final String JVM_RUNNER = "-runner.jar";
    private static final String QUARKUS_APP = "quarkus-app";
    private static final String QUARKUS_RUN = "quarkus-run.jar";
    private final ServiceLoader<QuarkusApplicationManagedResourceBinding> managedResourceBindingsRegistry = ServiceLoader.load(QuarkusApplicationManagedResourceBinding.class);
    private Path artifact;
    private QuarkusManagedResource managedResource;

    protected Path getArtifact() {
        return this.artifact;
    }

    @Override
    public void init(Annotation annotation) {
        QuarkusApplication metadata = (QuarkusApplication)annotation;
        this.setSslEnabled(metadata.ssl());
        this.setGrpcEnabled(metadata.grpc());
        this.initAppClasses(metadata.classes());
    }

    @Override
    public ManagedResource build(ServiceContext context) {
        this.setContext(context);
        this.configureLogging();
        this.managedResource = this.findManagedResource();
        this.build();
        this.managedResource.validate();
        return this.managedResource;
    }

    @Override
    public void build() {
        this.managedResource.onPreBuild();
        this.copyResourcesToAppFolder();
        if (this.managedResource.needsBuildArtifact()) {
            this.tryToReuseOrBuildArtifact();
        }
        this.managedResource.onPostBuild();
    }

    protected QuarkusManagedResource findManagedResource() {
        for (QuarkusApplicationManagedResourceBinding binding : this.managedResourceBindingsRegistry) {
            if (!binding.appliesFor(this.getContext())) continue;
            return binding.init(this);
        }
        return new ProdLocalhostQuarkusApplicationManagedResource(this);
    }

    protected Path getTargetFolderForLocalArtifacts() {
        return Paths.get(TARGET, new String[0]);
    }

    private void tryToReuseOrBuildArtifact() {
        Optional<Object> artifactLocation = Optional.empty();
        if (!this.containsBuildProperties() && !this.isSelectedAppClasses()) {
            if (QuarkusProperties.isNativePackageType(this.getContext())) {
                Object nativeRunnerExpectedLocation = NATIVE_RUNNER;
                if (OS.WINDOWS.isCurrentOs()) {
                    nativeRunnerExpectedLocation = (String)nativeRunnerExpectedLocation + EXE;
                }
                artifactLocation = FileUtils.findTargetFile(this.getTargetFolderForLocalArtifacts(), (String)nativeRunnerExpectedLocation);
            } else {
                artifactLocation = FileUtils.findTargetFile(this.getTargetFolderForLocalArtifacts(), JVM_RUNNER).or(() -> FileUtils.findTargetFile(this.getTargetFolderForLocalArtifacts().resolve(QUARKUS_APP), QUARKUS_RUN));
            }
        }
        this.artifact = artifactLocation.isEmpty() ? this.buildArtifact() : Path.of((String)artifactLocation.get(), new String[0]);
    }

    private Path buildArtifact() {
        try {
            AugmentResult result;
            this.createSnapshotOfBuildProperties();
            Path appFolder = this.getApplicationFolder();
            JavaArchive javaArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses((Class[])this.getAppClasses());
            ((ExplodedExporter)javaArchive.as(ExplodedExporter.class)).exportExplodedInto(appFolder.toFile());
            Path testLocation = PathTestHelper.getTestClassesLocation((Class)this.getContext().getTestContext().getRequiredTestClass());
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setApplicationRoot(appFolder).setMode(QuarkusBootstrap.Mode.PROD).addExcludedPath(testLocation).setIsolateDeployment(true).setProjectRoot(testLocation).setBaseName(this.getContext().getName()).setTargetDirectory(appFolder);
            ReflectionUtils.invokeMethod(builder, "setLocalProjectDiscovery", true);
            try (CuratedApplication curatedApplication = builder.build().bootstrap();){
                AugmentAction action = curatedApplication.createAugmentor();
                result = action.createProductionApplication();
            }
            return Optional.ofNullable(result.getNativeResult()).orElseGet(() -> result.getJar().getPath());
        }
        catch (Exception ex) {
            Assertions.fail((String)("Failed to build Quarkus artifacts. Caused by " + ex));
            return null;
        }
    }
}

