/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.ManagedResourceBuilder;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.utils.ClassPathUtils;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.MapUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class QuarkusApplicationManagedResourceBuilder
implements ManagedResourceBuilder {
    public static final String QUARKUS_HTTP_PORT_PROPERTY = "quarkus.http.port";
    public static final String QUARKUS_GRPC_SERVER_PORT_PROPERTY = "quarkus.grpc.server.port";
    public static final String QUARKUS_HTTP_SSL_PORT_PROPERTY = "quarkus.http.ssl-port";
    public static final int HTTP_PORT_DEFAULT = 8080;
    protected static final Path RESOURCES_FOLDER = Paths.get("src", "main", "resources");
    private static final String BUILD_TIME_PROPERTIES = "/build-time-list";
    private static final Path TEST_RESOURCES_FOLDER = Paths.get("src", "test", "resources");
    private static final String APPLICATION_PROPERTIES = "application.properties";
    private static final Set<String> BUILD_PROPERTIES = FileUtils.loadFile("/build-time-list").lines().collect(Collectors.toSet());
    private Class<?>[] appClasses;
    private boolean selectedAppClasses = true;
    private ServiceContext context;
    private boolean sslEnabled = false;
    private boolean grpcEnabled = false;
    private Map<String, String> propertiesSnapshot;

    protected abstract void build();

    protected ServiceContext getContext() {
        return this.context;
    }

    protected void setContext(ServiceContext context) {
        this.context = context;
    }

    protected boolean isSslEnabled() {
        return this.sslEnabled;
    }

    protected void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    protected boolean isGrpcEnabled() {
        return this.grpcEnabled;
    }

    protected void setGrpcEnabled(boolean grpcEnabled) {
        this.grpcEnabled = grpcEnabled;
    }

    protected Class<?>[] getAppClasses() {
        return this.appClasses;
    }

    protected boolean isSelectedAppClasses() {
        return this.selectedAppClasses;
    }

    public boolean containsBuildProperties() {
        Map<String, String> differenceProperties = MapUtils.difference(this.context.getOwner().getProperties(), this.propertiesSnapshot);
        Set<String> properties = differenceProperties.keySet();
        if (properties.isEmpty()) {
            return false;
        }
        return properties.stream().anyMatch(this::isBuildProperty);
    }

    public Map<String, String> createSnapshotOfBuildProperties() {
        this.propertiesSnapshot = new HashMap<String, String>(this.context.getOwner().getProperties());
        return new HashMap<String, String>(this.context.getOwner().getProperties());
    }

    public Map<String, String> getBuildProperties() {
        return this.getContext().getOwner().getProperties().entrySet().stream().filter(e -> this.isBuildProperty((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void initAppClasses(Class<?>[] classes) {
        this.appClasses = classes;
        if (this.appClasses == null || this.appClasses.length == 0) {
            this.appClasses = ClassPathUtils.findAllClassesFromSource();
            this.selectedAppClasses = false;
        }
    }

    protected void configureLogging() {
        this.context.getOwner().withProperty("quarkus.log.console.format", "%d{HH:mm:ss,SSS} %s%e%n");
    }

    protected void copyResourcesToAppFolder() {
        this.copyResourcesInFolderToAppFolder(RESOURCES_FOLDER);
        this.copyResourcesInFolderToAppFolder(TEST_RESOURCES_FOLDER);
        this.createEffectiveApplicationProperties();
    }

    protected Path getApplicationFolder() {
        return this.context.getServiceFolder();
    }

    protected Path getResourcesApplicationFolder() {
        return this.getApplicationFolder();
    }

    private void createEffectiveApplicationProperties() {
        Path applicationProperties = this.getResourcesApplicationFolder().resolve(APPLICATION_PROPERTIES);
        HashMap<String, String> map = new HashMap<String, String>();
        if (Files.exists(applicationProperties, new LinkOption[0])) {
            map.putAll(PropertiesUtils.toMap(applicationProperties));
        }
        map.putAll(this.context.getOwner().getProperties());
        PropertiesUtils.fromMap(map, applicationProperties);
    }

    private boolean isBuildProperty(String name) {
        return BUILD_PROPERTIES.stream().anyMatch(build -> name.matches((String)build) || build.endsWith(".") && name.startsWith((String)build) || name.equals(build));
    }

    private void copyResourcesInFolderToAppFolder(Path folder) {
        try (Stream<Path> binariesFound = Files.find(folder, Integer.MAX_VALUE, (path, basicFileAttributes) -> !Files.isDirectory(path, new LinkOption[0]), new FileVisitOption[0]);){
            binariesFound.forEach(path -> {
                File fileToCopy = path.toFile();
                Path source = folder.relativize((Path)path).getParent();
                Path target = this.getResourcesApplicationFolder();
                if (source != null) {
                    target = target.resolve(source);
                    target.toFile().mkdirs();
                }
                FileUtils.copyFileTo(fileToCopy, target);
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

