/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import java.util.Arrays;
import java.util.List;

public abstract class QuarkusManagedResource
implements ManagedResource {
    private static final String EXPECTED_OUTPUT_FROM_SUCCESSFULLY_STARTED = "features";
    private static final List<String> ERRORS = Arrays.asList("Failed to start application", "Failed to load config value of type class", "Quarkus may already be running or the port is used by another application", "One or more configuration errors have prevented the application from starting", "Attempting to start live reload endpoint to recover from previous Quarkus startup failure");
    private final ServiceContext serviceContext;
    private final LaunchMode launchMode;

    public QuarkusManagedResource(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.launchMode = QuarkusManagedResource.detectLaunchMode(serviceContext);
    }

    @Override
    public String getDisplayName() {
        return String.format("Quarkus %s mode", new Object[]{this.getLaunchMode()});
    }

    @Override
    public boolean isRunning() {
        if (this.getLoggingHandler() != null && this.getLoggingHandler().logsContains(EXPECTED_OUTPUT_FROM_SUCCESSFULLY_STARTED)) {
            this.getLoggingHandler().flush();
            return true;
        }
        return false;
    }

    @Override
    public boolean isFailed() {
        return this.getLoggingHandler() != null && ERRORS.stream().anyMatch(error -> this.getLoggingHandler().logsContains((String)error));
    }

    public boolean isNativeTest() {
        return this.getLaunchMode() == LaunchMode.NATIVE;
    }

    public void onPreBuild() {
    }

    public void onPostBuild() {
    }

    protected ServiceContext getContext() {
        return this.serviceContext;
    }

    protected abstract LoggingHandler getLoggingHandler();

    protected LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    protected boolean needsBuildArtifact() {
        return true;
    }

    protected void validate() {
    }

    private static LaunchMode detectLaunchMode(ServiceContext serviceContext) {
        LaunchMode launchMode = LaunchMode.JVM;
        if (QuarkusProperties.isNativePackageType(serviceContext)) {
            launchMode = LaunchMode.NATIVE;
        } else if (QuarkusProperties.isLegacyJarPackageType(serviceContext)) {
            launchMode = LaunchMode.LEGACY_JAR;
        }
        return launchMode;
    }
}

