/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.tracing;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.tracing.QuarkusScenarioTags;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class QuarkusScenarioSpan {
    private final Tracer tracer;
    private final QuarkusScenarioTags quarkusScenarioTags;
    private final Map<String, Span> spanBucket = new ConcurrentHashMap<String, Span>();

    public QuarkusScenarioSpan(Tracer tracer, QuarkusScenarioTags quarkusScenarioTags) {
        this.quarkusScenarioTags = quarkusScenarioTags;
        this.tracer = tracer;
    }

    public Span getOrCreate(ScenarioContext context) {
        String operationName = this.getOperationName(context);
        if (!this.spanBucket.containsKey(operationName)) {
            return this.buildNewSpan(operationName, context.getTestContext().getTags());
        }
        return this.spanBucket.get(operationName);
    }

    public Span save(Map<String, ?> logs, Set<String> tags, ScenarioContext scenarioContext) {
        String operationName = this.getOperationName(scenarioContext);
        Span span = this.spanBucket.get(operationName);
        span.log(logs);
        tags.forEach(tag -> span.setTag(tag, true));
        return span;
    }

    public String getOperationName(ScenarioContext scenarioContext) {
        Object operationName = scenarioContext.getRunningTestClassName();
        Optional<String> methodName = scenarioContext.getRunningTestMethodName();
        if (methodName.isPresent()) {
            operationName = (String)operationName + "_" + methodName.get();
        }
        return operationName;
    }

    private Span buildNewSpan(String operationName, Set<String> tags) {
        Span span = this.tracer.buildSpan(operationName).start();
        this.quarkusScenarioTags.initializedTags(span, tags);
        this.spanBucket.put(operationName, span);
        return span;
    }
}

