/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.tracing;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.quarkus.test.utils.TestExecutionProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class QuarkusScenarioTags {
    public static final String SUCCESS = "success";
    public static final String ERROR = "error";
    private final Map<String, String> globalTags = new HashMap<String, String>();

    public QuarkusScenarioTags() {
        this.globalTags.put("buildNumber", TestExecutionProperties.getBuildNumber());
        this.globalTags.put("versionNumber", TestExecutionProperties.getVersionNumber());
        this.addPlatformTag();
    }

    public void initializedTags(Span span, Set<String> contextTags) {
        contextTags.forEach(tag -> span.setTag(tag, true));
        this.globalTags.entrySet().forEach(gTag -> span.setTag((String)gTag.getKey(), (String)gTag.getValue()));
    }

    public void setTag(Span span, String tagName) {
        span.setTag(tagName, true);
    }

    public void setErrorTag(Span span) {
        Tags.ERROR.set(span, Boolean.valueOf(true));
    }

    private void addPlatformTag() {
        if (TestExecutionProperties.isOpenshiftPlatform()) {
            this.globalTags.put("ocp", "true");
        }
        if (TestExecutionProperties.isKubernetesPlatform()) {
            this.globalTags.put("k8s", "true");
        }
        if (TestExecutionProperties.isBareMetalPlatform()) {
            this.globalTags.put("bare-metal", "true");
        }
    }
}

