/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.tracing;

import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.tracing.QuarkusScenarioSpan;
import io.quarkus.test.tracing.QuarkusScenarioTags;
import io.quarkus.test.utils.TestExecutionProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.thrift.transport.TTransportException;

public class QuarkusScenarioTracer {
    private final Tracer tracer;
    private final QuarkusScenarioSpan quarkusScenarioSpan;
    private final QuarkusScenarioTags quarkusScenarioTags;

    public QuarkusScenarioTracer(String jaegerHttpEndpoint) throws TTransportException {
        this.tracer = new JaegerTracer.Builder(TestExecutionProperties.getServiceName()).withReporter((Reporter)new RemoteReporter.Builder().withSender((Sender)new HttpSender.Builder(jaegerHttpEndpoint).build()).build()).withSampler((Sampler)new ConstSampler(true)).build();
        this.quarkusScenarioTags = new QuarkusScenarioTags();
        this.quarkusScenarioSpan = new QuarkusScenarioSpan(this.tracer, this.quarkusScenarioTags);
    }

    public void updateWithTag(ScenarioContext context, String tag) {
        this.quarkusScenarioSpan.save(Collections.emptyMap(), QuarkusScenarioTracer.newHashSet(tag), context);
    }

    public void finishWithSuccess(ScenarioContext context) {
        this.finishWithSuccess(context, "success");
    }

    public void finishWithSuccess(ScenarioContext context, String tag) {
        this.quarkusScenarioSpan.save(Collections.emptyMap(), QuarkusScenarioTracer.newHashSet(tag), context).finish();
    }

    public void finishWithError(ScenarioContext context, Throwable cause) {
        this.finishWithError(context, cause, "error");
    }

    public void finishWithError(ScenarioContext context, Throwable cause, String tag) {
        Map<String, String> err = Map.of("event", "error", "error.object", cause, "message", cause.getMessage());
        this.quarkusScenarioSpan.save(err, QuarkusScenarioTracer.newHashSet(tag), context).finish();
    }

    public Span createSpanContext(ScenarioContext context) {
        return this.quarkusScenarioSpan.getOrCreate(context);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public QuarkusScenarioTags getTestFrameworkTags() {
        return this.quarkusScenarioTags;
    }

    private static Set<String> newHashSet(String ... values) {
        HashSet<String> set = new HashSet<String>();
        Stream.of(values).forEach(set::add);
        return set;
    }
}

