/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.tracing;

import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.tracing.QuarkusScenarioTracer;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.transport.TTransportException;

public class TracingExtensionBootstrap
implements ExtensionBootstrap {
    public static final String TRACING_ID = "tracing";
    private static final PropertyLookup JAEGER_HTTP_ENDPOINT_SYSTEM_PROPERTY = new PropertyLookup("tracing.jaeger.endpoint");
    private QuarkusScenarioTracer quarkusScenarioTracer;

    public TracingExtensionBootstrap() {
        String jaegerHttpEndpoint = JAEGER_HTTP_ENDPOINT_SYSTEM_PROPERTY.get();
        if (StringUtils.isNotEmpty((CharSequence)jaegerHttpEndpoint)) {
            try {
                this.quarkusScenarioTracer = new QuarkusScenarioTracer(jaegerHttpEndpoint);
            }
            catch (TTransportException e) {
                Log.error("Error setting up tracing capabilities. Turning off the tracing. Caused by: " + e.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public boolean appliesFor(ScenarioContext context) {
        return this.quarkusScenarioTracer != null;
    }

    @Override
    public void beforeAll(ScenarioContext context) {
        context.getTestStore().put((Object)TRACING_ID, (Object)this.quarkusScenarioTracer);
        this.quarkusScenarioTracer.createSpanContext(context);
    }

    @Override
    public void beforeEach(ScenarioContext context) {
        this.quarkusScenarioTracer.createSpanContext(context);
    }

    @Override
    public void onError(ScenarioContext context, Throwable throwable) {
        this.quarkusScenarioTracer.finishWithError(context, throwable);
    }

    @Override
    public void onSuccess(ScenarioContext context) {
        this.quarkusScenarioTracer.finishWithSuccess(context);
    }
}

