/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.tracing;

import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.ServiceListener;
import io.quarkus.test.tracing.QuarkusScenarioTracer;
import java.util.Optional;

public class TracingServiceListener
implements ServiceListener {
    @Override
    public void onServiceStarted(ServiceContext service) {
        this.getTracer(service.getScenarioContext()).ifPresent(tracer -> tracer.updateWithTag(service.getScenarioContext(), service.getName()));
    }

    @Override
    public void onServiceError(ServiceContext service, Throwable throwable) {
        this.getTracer(service.getScenarioContext()).ifPresent(tracer -> tracer.finishWithError(service.getScenarioContext(), throwable, service.getName()));
    }

    private Optional<QuarkusScenarioTracer> getTracer(ScenarioContext scenario) {
        Object tracer = scenario.getTestStore().get((Object)"tracing");
        if (tracer == null) {
            return Optional.empty();
        }
        return Optional.of((QuarkusScenarioTracer)tracer);
    }
}

