/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.logging.Log;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.EvaluatedCondition;
import org.awaitility.core.ThrowingRunnable;
import org.awaitility.core.TimeoutEvent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class AwaitilityUtils {
    private static final String TIMEOUT_FACTOR_PROPERTY = "factor.timeout";
    private static final int POLL_SECONDS = 1;
    private static final int TIMEOUT_SECONDS = 30;

    private AwaitilityUtils() {
    }

    public static void untilIsFalse(Callable<Boolean> supplier) {
        AwaitilityUtils.untilIsFalse(supplier, AwaitilitySettings.defaults());
    }

    public static void untilIsFalse(Callable<Boolean> supplier, AwaitilitySettings settings) {
        AwaitilityUtils.awaits(settings).until(() -> (Boolean)supplier.call() == false);
    }

    public static void untilIsTrue(Callable<Boolean> supplier) {
        AwaitilityUtils.untilIsTrue(supplier, AwaitilitySettings.defaults());
    }

    public static void untilIsTrue(Callable<Boolean> supplier, AwaitilitySettings settings) {
        AwaitilityUtils.awaits(settings).until(supplier);
    }

    public static <T> T untilIsNotNull(Supplier<T> supplier) {
        return AwaitilityUtils.until(supplier, Matchers.notNullValue());
    }

    public static <T> T[] untilIsNotEmpty(Supplier<T[]> supplier) {
        return AwaitilityUtils.until(supplier, Matchers.arrayWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    public static <T> void untilAsserted(Supplier<T> supplier, Consumer<T> asserts) {
        AwaitilityUtils.awaits().untilAsserted(() -> asserts.accept(AwaitilityUtils.get(supplier).call()));
    }

    public static void untilAsserted(ThrowingRunnable assertion) {
        AwaitilityUtils.awaits().untilAsserted(assertion);
    }

    public static <T> T until(Supplier<T> supplier, Matcher<T> matcher) {
        return (T)AwaitilityUtils.awaits().until(AwaitilityUtils.get(supplier), matcher);
    }

    private static <T> Callable<T> get(Supplier<T> supplier) {
        return () -> {
            Object instance = supplier.get();
            Log.debug("Checking ... {}", instance);
            return instance;
        };
    }

    private static ConditionFactory awaits() {
        return AwaitilityUtils.awaits(AwaitilitySettings.defaults());
    }

    private static ConditionFactory awaits(AwaitilitySettings settings) {
        ConditionFactory factory = Awaitility.await().pollInterval(settings.interval.toSeconds(), TimeUnit.SECONDS).atMost(AwaitilityUtils.timeoutInSeconds(settings), TimeUnit.SECONDS);
        if (!settings.doNotIgnoreExceptions) {
            factory = factory.ignoreExceptions();
        }
        if (settings.service != null || StringUtils.isNotEmpty((CharSequence)settings.timeoutMessage)) {
            factory = factory.conditionEvaluationListener((ConditionEvaluationListener)new CustomConditionEvaluationListener(settings));
        }
        return factory;
    }

    private static long timeoutInSeconds(AwaitilitySettings settings) {
        double timeoutFactor = 1.0;
        if (settings.service != null) {
            timeoutFactor = settings.service.getConfiguration().getAsDouble(TIMEOUT_FACTOR_PROPERTY, timeoutFactor);
        }
        return Math.round((double)settings.timeout.toSeconds() * timeoutFactor);
    }

    public static final class AwaitilitySettings {
        Duration interval = Duration.ofSeconds(1L);
        Duration timeout = Duration.ofSeconds(30L);
        Service service;
        String timeoutMessage = "";
        boolean doNotIgnoreExceptions = false;

        public AwaitilitySettings withService(Service service) {
            this.service = service;
            return this;
        }

        public AwaitilitySettings timeoutMessage(String message, Object ... args) {
            this.timeoutMessage = String.format(message, args);
            return this;
        }

        public AwaitilitySettings doNotIgnoreExceptions() {
            this.doNotIgnoreExceptions = true;
            return this;
        }

        public static AwaitilitySettings defaults() {
            return new AwaitilitySettings();
        }

        public static AwaitilitySettings usingTimeout(Duration timeout) {
            AwaitilitySettings settings = AwaitilitySettings.defaults();
            settings.timeout = timeout;
            return settings;
        }

        public static AwaitilitySettings using(Duration interval, Duration timeout) {
            AwaitilitySettings settings = AwaitilitySettings.defaults();
            settings.interval = interval;
            settings.timeout = timeout;
            return settings;
        }
    }

    public static final class CustomConditionEvaluationListener
    implements ConditionEvaluationListener {
        final AwaitilitySettings settings;

        CustomConditionEvaluationListener(AwaitilitySettings settings) {
            this.settings = settings;
        }

        public void conditionEvaluated(EvaluatedCondition condition) {
            if (this.settings.service != null) {
                Log.debug(this.settings.service, condition.getDescription(), new Object[0]);
            } else {
                Log.debug(condition.getDescription(), new Object[0]);
            }
        }

        public void onTimeout(TimeoutEvent timeoutEvent) {
            String message = timeoutEvent.getDescription();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                message = this.settings.timeoutMessage;
            }
            if (this.settings.service != null) {
                Log.warn(this.settings.service, message, new Object[0]);
            } else {
                Log.warn(message, new Object[0]);
            }
        }
    }
}

