/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.logging.Log;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.OS;

public final class ClassPathUtils {
    private static final Path SOURCE_CLASSES_LOCATION = Paths.get("target", "classes");
    private static final String CLASS_SUFFIX = ".class";

    private ClassPathUtils() {
    }

    public static Class<?>[] findAllClassesFromSource() {
        LinkedList classes = new LinkedList();
        try {
            if (!Files.exists(SOURCE_CLASSES_LOCATION, new LinkOption[0])) {
                return new Class[0];
            }
            try (Stream<Path> stream = Files.walk(SOURCE_CLASSES_LOCATION, new FileVisitOption[0]);){
                stream.map(Path::toString).filter(s -> s.endsWith(CLASS_SUFFIX)).map(ClassPathUtils::normalizeClassName).forEach(className -> {
                    try {
                        classes.add(Thread.currentThread().getContextClassLoader().loadClass((String)className));
                    }
                    catch (ClassNotFoundException ex) {
                        Log.warn("Could not load %s. Caused by: %s", className, ex);
                    }
                });
            }
        }
        catch (Exception ex) {
            Assertions.fail((String)("Can't load source classes location. Caused by " + ex.getMessage()));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static String normalizeClassName(String path) {
        String source = SOURCE_CLASSES_LOCATION.relativize(Paths.get(path, new String[0])).toString().replace(CLASS_SUFFIX, "");
        source = OS.WINDOWS.isCurrentOs() ? source.replace("\\", ".") : source.replace("/", ".");
        return source;
    }
}

