/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.logging.Log;
import io.quarkus.test.utils.ProcessBuilderProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class Command {
    private final String description;
    private final List<String> command;
    private BiConsumer<String, InputStream> outputConsumer = Command.consoleOutput();
    private String directory = ".";

    public Command(String ... command) {
        this(Arrays.asList(command));
    }

    public Command(List<String> command) {
        this.description = Command.descriptionOfProgram(command.get(0));
        this.command = command;
    }

    public Command outputToConsole() {
        this.outputConsumer = Command.consoleOutput();
        return this;
    }

    public Command outputToLines(List<String> output) {
        this.outputConsumer = Command.linesOutput(output);
        return this;
    }

    public Command onDirectory(Path path) {
        this.directory = path.toString();
        return this;
    }

    private static String descriptionOfProgram(String program) {
        if (program.contains(File.separator)) {
            return program.substring(program.lastIndexOf(File.separator) + 1);
        }
        return program;
    }

    public void runAndWait() throws IOException, InterruptedException {
        Log.info("Running command: %s", String.join((CharSequence)" ", this.command));
        Process process = ProcessBuilderProvider.command(this.command).redirectErrorStream(true).directory(new File(this.directory).getAbsoluteFile()).start();
        new Thread(() -> this.outputConsumer.accept(this.description, process.getInputStream()), "stdout consumer for command " + this.description).start();
        int result = process.waitFor();
        if (result != 0) {
            throw new RuntimeException(this.description + " failed (executed " + this.command + ", return code " + result + ")");
        }
    }

    private static BiConsumer<String, InputStream> linesOutput(List<String> lines) {
        return (description, is) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Log.info("%s: %s", description, line);
                    lines.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
    }

    private static BiConsumer<String, InputStream> consoleOutput() {
        return (description, is) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Log.info("%s: %s", description, line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
    }
}

