/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class FileUtils {
    private static final int NO_RECURSIVE = 1;
    private static final String TARGET = "target";

    private FileUtils() {
    }

    public static Path copyContentTo(String content, Path target) {
        try {
            Files.writeString(target, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed when writing file " + target + ". Caused by " + e.getMessage()));
        }
        return target;
    }

    public static String loadFile(File file) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not load file " + file + " . Caused by " + e.getMessage()));
            return null;
        }
    }

    public static String loadFile(String file) {
        try {
            return IOUtils.toString((InputStream)FileUtils.class.getResourceAsStream(file), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not load file " + file + " . Caused by " + e.getMessage()));
            return null;
        }
    }

    public static void recreateDirectory(Path folder) {
        FileUtils.deletePath(folder);
        FileUtils.createDirectory(folder);
    }

    public static void createDirectory(Path folder) {
        try {
            org.apache.commons.io.FileUtils.forceMkdir((File)folder.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createDirectoryIfDoesNotExist(Path folder) {
        if (!Files.exists(folder, new LinkOption[0])) {
            folder.toFile().mkdirs();
        }
    }

    public static void copyFileTo(File file, Path target) {
        try {
            org.apache.commons.io.FileUtils.copyFileToDirectory((File)file, (File)target.toFile());
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not copy project. Caused by " + e.getMessage()));
        }
    }

    public static void copyFileTo(String resourceFileName, Path targetPath) {
        try (InputStream resources = FileUtils.class.getClassLoader().getResourceAsStream(resourceFileName);){
            Files.copy(resources, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyCurrentDirectoryTo(Path target) {
        try {
            org.apache.commons.io.FileUtils.copyDirectory((File)Paths.get(".", new String[0]).toFile(), (File)target.toFile(), path -> !StringUtils.contains((CharSequence)path.toString(), (CharSequence)TARGET));
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not copy project. Caused by " + e.getMessage()));
        }
    }

    public static void deletePath(Path folder) {
        FileUtils.deleteFile(folder.toFile());
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Optional<String> findTargetFile(Path basePath, String endsWith) {
        Optional<String> optional;
        block8: {
            Stream<Path> binariesFound = Files.find(basePath, 1, (path, basicFileAttributes) -> path.toFile().getName().endsWith(endsWith), new FileVisitOption[0]);
            try {
                optional = binariesFound.map(path -> path.normalize().toString()).findFirst();
                if (binariesFound == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (binariesFound != null) {
                        try {
                            binariesFound.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return Optional.empty();
                }
            }
            binariesFound.close();
        }
        return optional;
    }
}

