/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.utils.Command;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;

public final class GitUtils {
    private static final String GIT = "git";
    private static final String CLONE = "clone";
    private static final String CHECKOUT = "checkout";

    private GitUtils() {
    }

    public static void cloneRepository(ServiceContext serviceContext, String repository) {
        try {
            new Command(Arrays.asList(GIT, CLONE, repository, ".")).outputToConsole().onDirectory(serviceContext.getServiceFolder()).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to clone GIT repository " + repository + ". Caused by: " + e.getMessage()));
        }
    }

    public static void checkoutBranch(ServiceContext serviceContext, String branch) {
        try {
            new Command(Arrays.asList(GIT, CHECKOUT, branch)).outputToConsole().onDirectory(serviceContext.getServiceFolder()).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to checkout GIT branch " + branch + ". Caused by: " + e.getMessage()));
        }
    }
}

