/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.utils.AwaitilityUtils;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public class LogsVerifier {
    private final Service service;

    public LogsVerifier(Service service) {
        this.service = service;
    }

    public void assertContains(String expectedLog) {
        AwaitilityUtils.untilAsserted(() -> {
            List<String> actualLogs = this.service.getLogs();
            Assertions.assertTrue((boolean)actualLogs.stream().anyMatch(line -> line.contains(expectedLog)), (String)("Log does not contain " + expectedLog + ". Full logs: " + actualLogs));
        });
    }

    public void assertDoesNotContain(String unexpectedLog) {
        List<String> actualLogs = this.service.getLogs();
        Assertions.assertTrue((boolean)actualLogs.stream().noneMatch(line -> line.contains(unexpectedLog)), (String)("Log does contain " + unexpectedLog + ". Full logs: " + actualLogs));
    }
}

