/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.utils.Command;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.junit.jupiter.api.Assertions;

public final class MavenUtils {
    public static final String MVN_COMMAND = "mvn";
    public static final String PACKAGE_GOAL = "package";
    public static final String INSTALL_GOAL = "install";
    public static final String MVN_REPOSITORY_LOCAL = "maven.repo.local";
    public static final String SKIP_TESTS = "-DskipTests=true";
    public static final String SKIP_ITS = "-DskipITs=true";
    public static final String DISPLAY_ERRORS = "-e";
    public static final String BATCH_MODE = "-B";
    public static final String DISPLAY_VERSION = "-V";
    public static final String SKIP_CHECKSTYLE = "-Dcheckstyle.skip";
    public static final String QUARKUS_PROFILE = "quarkus.profile";
    public static final String QUARKUS_PROPERTY_PREFIX = "quarkus";
    public static final String POM_XML = "pom.xml";

    private MavenUtils() {
    }

    public static void build(ServiceContext serviceContext, Path basePath, List<String> extraMavenArgs) {
        List<String> command = MavenUtils.mvnCommand(serviceContext);
        command.addAll(extraMavenArgs);
        command.add(PACKAGE_GOAL);
        try {
            new Command(command).outputToConsole().onDirectory(basePath).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to build Maven. Caused by: " + e.getMessage()));
        }
    }

    public static List<String> devModeMavenCommand(ServiceContext serviceContext, List<String> systemProperties) {
        List<String> command = MavenUtils.mvnCommand(serviceContext);
        command.addAll(Arrays.asList(SKIP_CHECKSTYLE, SKIP_ITS));
        command.addAll(systemProperties);
        command.add(MavenUtils.withProperty("debug", "false"));
        command.add("quarkus:dev");
        return command;
    }

    public static List<String> mvnCommand(ServiceContext serviceContext) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(MVN_COMMAND);
        args.add(DISPLAY_ERRORS);
        args.add(MavenUtils.withQuarkusProfile(serviceContext));
        MavenUtils.withMavenRepositoryLocalIfSet(args);
        MavenUtils.withQuarkusProperties(args);
        return args;
    }

    public static String withProperty(String property, String value) {
        return String.format("-D%s=%s", property, value);
    }

    public static void installParentPomsIfNeeded() {
        MavenUtils.installParentPomsIfNeeded(Paths.get(".", new String[0]));
    }

    public static void installParentPomsIfNeeded(Path basePath) {
        Model mavenModel;
        if (Files.exists(basePath.resolve(POM_XML), new LinkOption[0]) && (mavenModel = MavenUtils.getMavenModel(basePath)) != null && mavenModel.getParent() != null) {
            Path relativePath = basePath.resolve((String)StringUtils.defaultIfBlank((CharSequence)mavenModel.getParent().getRelativePath(), (CharSequence)".."));
            MavenUtils.installParentPom(relativePath);
            MavenUtils.installParentPomsIfNeeded(relativePath);
        }
    }

    private static void installParentPom(Path relativePath) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(MVN_COMMAND, DISPLAY_ERRORS, INSTALL_GOAL, SKIP_CHECKSTYLE, SKIP_TESTS, SKIP_ITS, "-pl", "."));
        MavenUtils.withMavenRepositoryLocalIfSet(args);
        MavenUtils.withQuarkusProperties(args);
        Command cmd = new Command(args);
        cmd.onDirectory(relativePath);
        try {
            cmd.runAndWait();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String withQuarkusProfile(ServiceContext serviceContext) {
        return MavenUtils.withProperty(QUARKUS_PROFILE, serviceContext.getTestContext().getRequiredTestClass().getSimpleName());
    }

    private static void withMavenRepositoryLocalIfSet(List<String> args) {
        String mvnRepositoryPath = System.getProperty(MVN_REPOSITORY_LOCAL);
        if (mvnRepositoryPath != null) {
            args.add(MavenUtils.withProperty(MVN_REPOSITORY_LOCAL, mvnRepositoryPath));
        }
    }

    private static Model getMavenModel(Path basePath) {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        FileReader is = new FileReader(basePath.resolve(POM_XML).toFile());
        try {
            model = reader.read((Reader)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        is.close();
        return model;
    }

    private static void withQuarkusProperties(List<String> args) {
        System.getProperties().entrySet().stream().filter(MavenUtils.isQuarkusProperty().and(MavenUtils.propertyValueIsNotEmpty())).forEach(property -> {
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            args.add(MavenUtils.withProperty(key, value));
        });
    }

    private static Predicate<Map.Entry<Object, Object>> propertyValueIsNotEmpty() {
        return property -> StringUtils.isNotEmpty((CharSequence)((String)property.getValue()));
    }

    private static Predicate<Map.Entry<Object, Object>> isQuarkusProperty() {
        return property -> StringUtils.startsWith((CharSequence)((String)property.getKey()), (CharSequence)QUARKUS_PROPERTY_PREFIX);
    }
}

