/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.logging.Log;
import io.quarkus.test.utils.AwaitilityUtils;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.condition.OS;

public final class ProcessUtils {
    private static final int PROCESS_KILL_TIMEOUT_MINUTES = 3;

    private ProcessUtils() {
    }

    public static void destroy(Process process) {
        try {
            if (process != null) {
                process.children().forEach(child -> {
                    if (child.supportsNormalTermination()) {
                        child.destroyForcibly();
                    }
                    ProcessUtils.pidKiller(child.pid());
                    AwaitilityUtils.untilIsFalse(child::isAlive);
                });
                if (process.supportsNormalTermination()) {
                    process.destroy();
                    process.waitFor(3L, TimeUnit.MINUTES);
                }
                ProcessUtils.pidKiller(process.pid());
                AwaitilityUtils.untilIsFalse(process::isAlive);
            }
        }
        catch (Exception e) {
            Log.warn("Error trying to stop process. Caused by " + e.getMessage(), new Object[0]);
        }
    }

    private static void pidKiller(long pid) {
        try {
            if (OS.WINDOWS.isCurrentOs()) {
                Runtime.getRuntime().exec(new String[]{"cmd", "/C", "taskkill", "/PID", Long.toString(pid), "/F", "/T"});
            } else {
                Runtime.getRuntime().exec(new String[]{"kill", "-9", Long.toString(pid)});
            }
        }
        catch (Exception e) {
            Log.warn("Error stopping process " + pid, e);
        }
    }
}

