/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class PropertiesUtils {
    private static final String AUTOGENERATED_COMMENT = "This properties file has been auto generated by Quarkus QE Test Framework";
    private static final String PROPERTY_START_TAG = "${";
    private static final String PROPERTY_END_TAG = "}";
    private static final String PROPERTY_WITH_OPTIONAL = ":";

    private PropertiesUtils() {
    }

    public static String resolveProperty(String value) {
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)PROPERTY_START_TAG)) {
            String propertyKey = StringUtils.substringBetween((String)value, (String)PROPERTY_START_TAG, (String)PROPERTY_END_TAG);
            String defaultValue = "";
            int optionalIndex = propertyKey.indexOf(PROPERTY_WITH_OPTIONAL);
            if (optionalIndex > 0) {
                defaultValue = propertyKey.substring(optionalIndex + 1);
                propertyKey = propertyKey.substring(0, optionalIndex);
            }
            return System.getProperty(propertyKey, defaultValue);
        }
        return value;
    }

    public static Map<String, String> toMap(String propertiesFile) {
        Map<String, String> map;
        block8: {
            InputStream in = ClassLoader.getSystemResourceAsStream(propertiesFile);
            try {
                map = PropertiesUtils.toMap(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Assertions.fail((String)("Could not load map from system resource. Caused by " + e));
                    return null;
                }
            }
            in.close();
        }
        return map;
    }

    public static Map<String, String> toMap(Path path) {
        Map<String, String> map;
        block8: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                map = PropertiesUtils.toMap(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Assertions.fail((String)("Could not load map from path. Caused by " + e));
                    return null;
                }
            }
            in.close();
        }
        return map;
    }

    public static Map<String, String> toMap(InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not load map. Caused by " + e));
        }
        return properties;
    }

    public static void fromMap(Map<String, String> map, Path target) {
        try {
            Properties properties = new Properties();
            properties.putAll(map);
            properties.store(new FileOutputStream(target.toAbsolutePath().toFile()), AUTOGENERATED_COMMENT);
        }
        catch (Exception e) {
            Assertions.fail((String)("Could not create file in target. Caused by " + e));
        }
    }
}

