/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getStaticFieldValue(Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)("Can't resolve field value. Fields need to be in static. Problematic field: " + field.getName()));
            return null;
        }
    }

    public static void setStaticFieldValue(Field field, Object value) {
        field.setAccessible(true);
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                field.set(null, value);
            }
            catch (IllegalAccessException e) {
                Assertions.fail((String)("Couldn't set value. Fields can only be injected into static instances. Problematic field: " + field.getName()));
            }
        } else {
            Assertions.fail((String)("Fields can only be injected into static instances. Problematic field: " + field.getName()));
        }
    }

    public static List<Field> findAllFields(Class<?> clazz) {
        if (clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(ReflectionUtils.findAllFields(clazz.getSuperclass()));
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields;
    }

    public static Object invokeMethod(Object instance, String methodName, Object ... args) {
        for (Method method : instance.getClass().getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return org.junit.platform.commons.util.ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])args);
        }
        Assertions.fail((String)("Method " + methodName + " not found in " + instance.getClass()));
        return null;
    }
}

