/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.test.configuration.PropertyLookup;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class SocketUtils {
    private static final PropertyLookup PORT_RANGE_MIN_PROPERTY = new PropertyLookup("port.range.min", "1100");
    private static final PropertyLookup PORT_RANGE_MAX_PROPERTY = new PropertyLookup("port.range.max", "49151");
    private static final PropertyLookup PORT_RESOLUTION_STRATEGY_PROPERTY = new PropertyLookup("port.resolution.strategy");
    private static final int PORT_RANGE_MIN = PORT_RANGE_MIN_PROPERTY.getAsInteger();
    private static final int PORT_RANGE_MAX = PORT_RANGE_MAX_PROPERTY.getAsInteger();
    private static final String PORT_RESOLUTION_RANDOM_STRATEGY = "random";
    private static final AtomicInteger CURRENT_MIN_PORT = new AtomicInteger(PORT_RANGE_MIN);
    private static final Random RND = new Random(System.nanoTime());

    private SocketUtils() {
    }

    public static synchronized int findAvailablePort() {
        if (PORT_RESOLUTION_RANDOM_STRATEGY.equals(PORT_RESOLUTION_STRATEGY_PROPERTY.get())) {
            return SocketUtils.findRandomAvailablePort();
        }
        return SocketUtils.findNextAvailablePort();
    }

    public static int findRandomAvailablePort() {
        int candidatePort;
        int portRange = PORT_RANGE_MAX - PORT_RANGE_MIN;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available port in the range [%d, %d] after %d attempts", PORT_RANGE_MIN, PORT_RANGE_MAX, searchCounter));
            }
            candidatePort = PORT_RANGE_MIN + RND.nextInt(PORT_RANGE_MAX - PORT_RANGE_MIN + 1);
            ++searchCounter;
        } while (!SocketUtils.isPortAvailable(candidatePort));
        return candidatePort;
    }

    public static synchronized int findNextAvailablePort() {
        int candidate;
        do {
            if (!SocketUtils.isPortAvailable(candidate = CURRENT_MIN_PORT.incrementAndGet())) continue;
            return candidate;
        } while (candidate <= PORT_RANGE_MAX);
        throw new IllegalStateException(String.format("Could not find an available port in the range [%d, %d]", PORT_RANGE_MIN, PORT_RANGE_MAX));
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        if (port < PORT_RANGE_MIN || port > PORT_RANGE_MAX) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = new ServerSocket(port);
        try {
            ss.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ss.close();
        return bl;
    }
}

