/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import io.quarkus.builder.Version;
import io.quarkus.test.configuration.PropertyLookup;

public final class TestExecutionProperties {
    private static final String DEFAULT_SERVICE_NAME = "quarkus_test_framework";
    private static final String DEFAULT_BUILD_NUMBER = "777-default";
    private static final TestExecutionProperties INSTANCE = new TestExecutionProperties();
    private final String serviceName = new PropertyLookup("service-name", "quarkus_test_framework").get();
    private final String buildNumber = new PropertyLookup("build.number", "777-default").get();
    private final String versionNumber = new PropertyLookup("version-number", Version.getVersion()).get();
    private final boolean openshift = new PropertyLookup("openshift").getAsBoolean();
    private final boolean kubernetes = new PropertyLookup("kubernetes").getAsBoolean();

    private TestExecutionProperties() {
    }

    public static String getServiceName() {
        return TestExecutionProperties.INSTANCE.serviceName;
    }

    public static String getVersionNumber() {
        return TestExecutionProperties.INSTANCE.versionNumber;
    }

    public static boolean isKubernetesPlatform() {
        return TestExecutionProperties.INSTANCE.kubernetes;
    }

    public static boolean isOpenshiftPlatform() {
        return TestExecutionProperties.INSTANCE.openshift;
    }

    public static boolean isBareMetalPlatform() {
        return !TestExecutionProperties.isKubernetesPlatform() && !TestExecutionProperties.isOpenshiftPlatform();
    }

    public static String getBuildNumber() {
        return TestExecutionProperties.INSTANCE.buildNumber;
    }
}

