/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.KubectlClient;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.scenarios.KubernetesScenario;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class KubernetesExtensionBootstrap
implements ExtensionBootstrap {
    public static final String CLIENT = "kubectl-client";
    private static final PropertyLookup DELETE_NAMESPACE_AFTER = new PropertyLookup("ts.kubernetes.delete.namespace.after.all", Boolean.TRUE.toString());
    private KubectlClient client;

    public boolean appliesFor(ScenarioContext context) {
        return context.isAnnotationPresent(KubernetesScenario.class);
    }

    public void beforeAll(ScenarioContext context) {
        this.client = KubectlClient.create(context.getId());
    }

    public void afterAll(ScenarioContext context) {
        if (DELETE_NAMESPACE_AFTER.getAsBoolean().booleanValue()) {
            this.client.deleteNamespace();
        }
    }

    public void updateServiceContext(ServiceContext context) {
        context.put(CLIENT, (Object)this.client);
    }

    public Optional<Object> getParameter(Class<?> clazz) {
        if (clazz == KubectlClient.class) {
            return Optional.of(this.client);
        }
        return Optional.empty();
    }

    public void onError(ScenarioContext context, Throwable throwable) {
        Map<String, String> logs = this.client.logs();
        for (Map.Entry<String, String> podLog : logs.entrySet()) {
            FileUtils.copyContentTo((String)podLog.getValue(), (Path)Log.LOG_OUTPUT_DIRECTORY.resolve(podLog.getKey() + ".log"));
        }
    }
}

