/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap.inject;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class KubectlClient {
    private static final PropertyLookup ENABLED_EPHEMERAL_NAMESPACES = new PropertyLookup("ts.kubernetes.ephemeral.namespaces.enabled", Boolean.TRUE.toString());
    private static final String RESOURCE_PREFIX = "resource::";
    private static final String RESOURCE_MNT_FOLDER = "/resource";
    private static final int NAMESPACE_NAME_SIZE = 10;
    private static final int NAMESPACE_CREATION_RETRIES = 5;
    private static final String LABEL_TO_WATCH_FOR_LOGS = "tsLogWatch";
    private static final String LABEL_SCENARIO_ID = "scenarioId";
    private static final String KUBECTL = "kubectl";
    private static final int HTTP_PORT_DEFAULT = 80;
    private final String currentNamespace;
    private final DefaultOpenShiftClient masterClient;
    private final NamespacedOpenShiftClient client;
    private final String scenarioId;

    private KubectlClient(String scenarioUniqueName) {
        this.scenarioId = scenarioUniqueName;
        String activeNamespace = new DefaultOpenShiftClient().getNamespace();
        this.currentNamespace = ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean() != false ? this.createNamespace() : activeNamespace;
        OpenShiftConfig config = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withTrustCerts(true)).withNamespace(this.currentNamespace)).build();
        this.masterClient = new DefaultOpenShiftClient(config);
        this.client = this.masterClient.inNamespace(this.currentNamespace);
    }

    public static KubectlClient create(String scenarioName) {
        return new KubectlClient(scenarioName);
    }

    public String namespace() {
        return this.currentNamespace;
    }

    public void apply(Service service, Path file) {
        try {
            new Command(new String[]{KUBECTL, "apply", "-f", file.toAbsolutePath().toString(), "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + file.toAbsolutePath().toString() + " for " + service.getName() + ". Caused by " + e.getMessage()));
        }
    }

    public void applyServiceProperties(Service service, String file, UnaryOperator<String> update, Path target) {
        this.applyServiceProperties(service, file, update, Collections.emptyMap(), target);
    }

    public void applyServiceProperties(Service service, String file, UnaryOperator<String> update, Map<String, String> extraTemplateProperties, Path target) {
        String content = FileUtils.loadFile((String)file);
        content = this.enrichTemplate(service, (String)update.apply(content), extraTemplateProperties);
        this.apply(service, FileUtils.copyContentTo((String)content, (Path)target));
    }

    public void expose(Service service, Integer port) {
        try {
            new Command(new String[]{KUBECTL, "expose", "deployment", service.getName(), "--port=" + port, "--name=" + service.getName(), "--type=LoadBalancer", "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void scaleTo(Service service, int replicas) {
        try {
            new Command(new String[]{KUBECTL, "scale", "deployment/" + service.getName(), "--replicas=" + replicas, "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be scaled. Caused by " + e.getMessage()));
        }
    }

    public List<Pod> podsInService(Service service) {
        return ((PodList)((FilterWatchListDeletable)this.client.pods().withLabel(LABEL_TO_WATCH_FOR_LOGS, service.getName())).list()).getItems();
    }

    public Map<String, String> logs() {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : ((PodList)this.client.pods().list()).getItems()) {
            String podName = pod.getMetadata().getName();
            logs.put(podName, ((PodResource)this.client.pods().withName(podName)).getLog());
        }
        return logs;
    }

    public Map<String, String> logs(Service service) {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : this.podsInService(service)) {
            if (!this.isPodRunning(pod)) continue;
            String podName = pod.getMetadata().getName();
            logs.put(podName, ((PodResource)this.client.pods().withName(podName)).getLog());
        }
        return logs;
    }

    public String url(Service service) {
        Optional<String> ip;
        String serviceName = service.getName();
        io.fabric8.kubernetes.api.model.Service serviceModel = (io.fabric8.kubernetes.api.model.Service)((ServiceResource)this.client.services().withName(serviceName)).get();
        if (serviceModel == null || serviceModel.getStatus() == null || serviceModel.getStatus().getLoadBalancer() == null || serviceModel.getStatus().getLoadBalancer().getIngress() == null) {
            this.printServiceInfo(service);
            Assertions.fail((String)("Service " + serviceName + " not found"));
        }
        if ((ip = serviceModel.getStatus().getLoadBalancer().getIngress().stream().map(ingress -> (String)StringUtils.defaultIfBlank((CharSequence)ingress.getIp(), (CharSequence)ingress.getHostname())).filter(StringUtils::isNotEmpty).findFirst()).isEmpty()) {
            this.printServiceInfo(service);
            Assertions.fail((String)("Service " + serviceName + " host not found"));
        }
        return "http://" + ip.get();
    }

    public int port(Service service) {
        String serviceName = service.getName();
        io.fabric8.kubernetes.api.model.Service serviceModel = (io.fabric8.kubernetes.api.model.Service)((ServiceResource)this.client.services().withName(serviceName)).get();
        if (serviceModel == null || serviceModel.getSpec() == null || serviceModel.getSpec().getPorts() == null) {
            Assertions.fail((String)("Service " + serviceName + " not found"));
        }
        return serviceModel.getSpec().getPorts().stream().map(ServicePort::getPort).filter(Objects::nonNull).findFirst().orElse(80);
    }

    public void deleteNamespace() {
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            try {
                new Command(new String[]{KUBECTL, "delete", "namespace", this.currentNamespace}).runAndWait();
            }
            catch (Exception e) {
                Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
            }
            finally {
                this.masterClient.close();
            }
        } else {
            this.deleteResourcesByLabel(LABEL_SCENARIO_ID, this.getScenarioId());
        }
    }

    private String getScenarioId() {
        return this.scenarioId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResourcesByLabel(String labelName, String labelValue) {
        try {
            String label = String.format("%s=%s", labelName, labelValue);
            new Command(new String[]{KUBECTL, "delete", "-n", this.currentNamespace, "all", "-l", label}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
        }
        finally {
            this.masterClient.close();
        }
    }

    private boolean isPodRunning(Pod pod) {
        return pod.getStatus().getPhase().equals("Running");
    }

    private List<HasMetadata> loadYaml(String template) {
        return (List)this.client.load((InputStream)new ByteArrayInputStream(template.getBytes())).get();
    }

    private String enrichTemplate(Service service, String template, Map<String, String> extraTemplateProperties) {
        List<HasMetadata> objs = this.loadYaml(template);
        for (HasMetadata obj : objs) {
            obj.getMetadata().setNamespace(this.namespace());
            Map objMetadataLabels = Optional.ofNullable(obj.getMetadata().getLabels()).orElse(new HashMap());
            objMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            obj.getMetadata().setLabels(objMetadataLabels);
            if (!(obj instanceof Deployment)) continue;
            Deployment d = (Deployment)obj;
            d.getMetadata().setName(service.getName());
            d.getSpec().getTemplate().getMetadata().setNamespace(this.namespace());
            Map templateMetadataLabels = d.getSpec().getTemplate().getMetadata().getLabels();
            templateMetadataLabels.put(LABEL_TO_WATCH_FOR_LOGS, service.getName());
            templateMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), d);
            enrichProperties.putAll(extraTemplateProperties);
            d.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(property -> {
                String key = (String)property.getKey();
                EnvVar envVar = this.getEnvVarByKey(key, (Container)container);
                if (envVar == null) {
                    container.getEnv().add(new EnvVar(key, (String)property.getValue(), null));
                } else {
                    envVar.setValue((String)property.getValue());
                }
            }));
        }
        KubernetesList list = new KubernetesList();
        list.setItems(objs);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Serialization.yamlMapper().writeValue((OutputStream)os, (Object)list);
            template = new String(os.toByteArray());
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed adding properties into template. Caused by " + e.getMessage()));
        }
        return template;
    }

    private EnvVar getEnvVarByKey(String key, Container container) {
        return container.getEnv().stream().filter(env -> StringUtils.equals((CharSequence)key, (CharSequence)env.getName())).findFirst().orElse(null);
    }

    private Map<String, String> enrichProperties(Map<String, String> properties, Deployment deployment) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (this.isResource(entry.getValue())) {
                String path = entry.getValue().replace(RESOURCE_PREFIX, "");
                String fileName = path.substring(1);
                String configMapName = this.normalizeConfigMapName(fileName);
                this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(fileName, FileUtils.loadFile((String)path))).build()});
                deployment.getSpec().getTemplate().getSpec().getVolumes().add(((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(configMapName)).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(configMapName)).build())).build());
                deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(configMapName)).withReadOnly(Boolean.valueOf(true))).withMountPath(RESOURCE_MNT_FOLDER)).build()));
                value = RESOURCE_MNT_FOLDER + path;
            }
            output.put(entry.getKey(), (String)value);
        }
        return output;
    }

    private String normalizeConfigMapName(String name) {
        return name.replaceAll(Pattern.quote("."), "-");
    }

    private boolean isResource(String key) {
        return key.startsWith(RESOURCE_PREFIX);
    }

    private String createNamespace() {
        boolean namespaceCreated = false;
        String namespace = this.generateRandomNamespaceName();
        for (int index = 0; index < 5; ++index) {
            if (this.doCreateNamespace(namespace)) {
                namespaceCreated = true;
                break;
            }
            namespace = this.generateRandomNamespaceName();
        }
        if (!namespaceCreated) {
            Assertions.fail((String)"Namespace cannot be created. Review your Kubernetes installation.");
        }
        return namespace;
    }

    private boolean doCreateNamespace(String namespaceName) {
        boolean created = false;
        try {
            new Command(new String[]{KUBECTL, "create", "namespace", namespaceName}).runAndWait();
            created = true;
        }
        catch (Exception e) {
            Log.warn((String)("Namespace " + namespaceName + " failed to be created. Caused by: " + e.getMessage() + ". Trying again."), (Object[])new Object[0]);
        }
        return created;
    }

    private String generateRandomNamespaceName() {
        return ThreadLocalRandom.current().ints(10L, 97, 123).collect(() -> new StringBuilder("ts-"), StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private void printServiceInfo(Service service) {
        try {
            new Command(new String[]{KUBECTL, "get", "svc", service.getName(), "-n", this.currentNamespace}).outputToConsole().runAndWait();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

