/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.logging.FileServiceLoggingHandler;
import io.quarkus.test.logging.Log;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.services.quarkus.ArtifactQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.KubernetesQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.RemoteDevModeQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.utils.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RemoteDevModeKubernetesQuarkusApplicationManagedResource
extends KubernetesQuarkusApplicationManagedResource {
    private static final String REMOTE_DEV_LOG_OUTPUT_FILE = "remote-dev-out.log";
    private final RemoteDevModeQuarkusApplicationManagedResourceBuilder model;
    private Process remoteDevProcess;
    private File remoteDevLogFile;
    private LoggingHandler remoteDevLoggingHandler;

    public RemoteDevModeKubernetesQuarkusApplicationManagedResource(RemoteDevModeQuarkusApplicationManagedResourceBuilder model) {
        super((ArtifactQuarkusApplicationManagedResourceBuilder)model);
        this.model = model;
        this.remoteDevLogFile = new File(model.getContext().getServiceFolder().resolve(REMOTE_DEV_LOG_OUTPUT_FILE).toString());
    }

    public boolean isRunning() {
        if (super.isRunning()) {
            if (this.remoteDevProcess == null) {
                this.startRemoteDevProcess();
            }
            if (this.remoteDevLoggingHandler != null && this.remoteDevLoggingHandler.logsContains("Connected to remote server")) {
                this.remoteDevLoggingHandler.flush();
                return true;
            }
        }
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.remoteDevLoggingHandler != null) {
            this.remoteDevLoggingHandler.stopWatching();
        }
        ProcessUtils.destroy((Process)this.remoteDevProcess);
    }

    @Override
    protected Map<String, String> addExtraTemplateProperties() {
        HashMap<String, String> templateProperties = new HashMap<String, String>();
        templateProperties.putAll(super.addExtraTemplateProperties());
        templateProperties.put("QUARKUS_LAUNCH_DEVMODE", Boolean.TRUE.toString());
        templateProperties.put("quarkus.live-reload.password", this.model.getLiveReloadPassword());
        return templateProperties;
    }

    private synchronized void startRemoteDevProcess() {
        if (this.remoteDevProcess == null) {
            ProcessBuilder pb = this.model.prepareRemoteDevProcess();
            pb.redirectOutput(this.remoteDevLogFile);
            try {
                this.remoteDevProcess = pb.start();
                this.remoteDevLoggingHandler = new FileServiceLoggingHandler(this.model.getContext().getOwner(), this.remoteDevLogFile);
                this.remoteDevLoggingHandler.startWatching();
            }
            catch (IOException e) {
                Log.error((Service)this.getContext().getOwner(), (String)("Failed to start the remote dev process. Caused by " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }
}

